/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.FontException;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.registry.AbstractFontFileRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.truetype.NameTable;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeCollection;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFont;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontRecord;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class TrueTypeFontRegistry
extends AbstractFontFileRegistry {
    private static FontCache secondLevelCache;
    private static Log logger;
    private static final FontPathFilter FONTPATHFILTER;
    private HashMap fontFamilies = new HashMap();
    private HashMap alternateFamilyNames = new HashMap();
    private HashMap fullFontNames = new HashMap();

    protected static synchronized FontCache internalGetSecondLevelCache() {
        if (secondLevelCache == null) {
            secondLevelCache = LibFontBoot.getInstance().createDefaultCache();
        }
        return secondLevelCache;
    }

    @Override
    public FontCache getSecondLevelCache() {
        return TrueTypeFontRegistry.internalGetSecondLevelCache();
    }

    @Override
    protected FileFilter getFileFilter() {
        return FONTPATHFILTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean addFont(File file, String string) throws IOException {
        try {
            if (StringUtils.endsWithIgnoreCase((String)file.getName(), (String)".ttc")) {
                TrueTypeCollection trueTypeCollection = new TrueTypeCollection(file);
                int n = 0;
                while ((long)n < trueTypeCollection.getNumFonts()) {
                    TrueTypeFont trueTypeFont = null;
                    try {
                        trueTypeFont = trueTypeCollection.getFont(n);
                        this.registerTrueTypeFont(trueTypeFont);
                    }
                    finally {
                        if (trueTypeFont != null) {
                            trueTypeFont.dispose();
                        }
                    }
                    ++n;
                }
            } else {
                TrueTypeFont trueTypeFont = null;
                try {
                    trueTypeFont = new TrueTypeFont(file);
                    this.registerTrueTypeFont(trueTypeFont);
                }
                finally {
                    if (trueTypeFont != null) {
                        trueTypeFont.dispose();
                    }
                }
            }
            return true;
        }
        catch (Exception exception) {
            logger.info((Object)("Unable to register font file " + file), (Throwable)exception);
            return false;
        }
    }

    private void registerTrueTypeFont(TrueTypeFont trueTypeFont) throws IOException {
        NameTable nameTable = (NameTable)trueTypeFont.getTable(1851878757L);
        if (nameTable == null) {
            throw new IOException("The NameTable is required for all conforming fonts.");
        }
        String string = nameTable.getPrimaryName(1);
        DefaultFontFamily defaultFontFamily = this.createFamily(string);
        try {
            String[] stringArray = new TrueTypeFontRecord(trueTypeFont, defaultFontFamily);
            defaultFontFamily.addFontRecord((FontRecord)stringArray);
        }
        catch (FontException fontException) {
            logger.info((Object)("The font '" + trueTypeFont.getFilename() + "' is invalid."), (Throwable)((Object)fontException));
            return;
        }
        this.fontFamilies.put(string, defaultFontFamily);
        this.alternateFamilyNames.put(string, defaultFontFamily);
        for (String string2 : nameTable.getAllNames(1)) {
            defaultFontFamily.addName(string2);
            this.alternateFamilyNames.put(string2, defaultFontFamily);
        }
        for (String string3 : nameTable.getAllNames(4)) {
            this.fullFontNames.put(string3, defaultFontFamily);
        }
    }

    private DefaultFontFamily createFamily(String string) {
        DefaultFontFamily defaultFontFamily = (DefaultFontFamily)this.fontFamilies.get(string);
        if (defaultFontFamily != null) {
            return defaultFontFamily;
        }
        return new DefaultFontFamily(string);
    }

    @Override
    public String[] getRegisteredFamilies() {
        return this.fontFamilies.keySet().toArray(new String[this.fontFamilies.size()]);
    }

    @Override
    public String[] getAllRegisteredFamilies() {
        return this.alternateFamilyNames.keySet().toArray(new String[this.alternateFamilyNames.size()]);
    }

    @Override
    public FontFamily getFontFamily(String string) {
        FontFamily fontFamily = (FontFamily)this.fontFamilies.get(string);
        if (fontFamily != null) {
            return fontFamily;
        }
        FontFamily fontFamily2 = (FontFamily)this.alternateFamilyNames.get(string);
        if (fontFamily2 != null) {
            return fontFamily2;
        }
        return (FontFamily)this.fullFontNames.get(string);
    }

    @Override
    public FontMetricsFactory createMetricsFactory() {
        return new TrueTypeFontMetricsFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadFromCache(String string) {
        ResourceManager resourceManager = new ResourceManager();
        resourceManager.registerDefaults();
        File file = this.createStorageLocation();
        if (file == null) {
            return;
        }
        File file2 = new File(file, "ttf-fontcache.ser");
        try {
            HashMap hashMap;
            HashMap hashMap2;
            HashMap hashMap3;
            HashMap hashMap4;
            ResourceKey resourceKey = resourceManager.createKey((Object)file2);
            ResourceData resourceData = resourceManager.load(resourceKey);
            InputStream inputStream = resourceData.getResourceAsStream(resourceManager);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                Object[] objectArray = (Object[])objectInputStream.readObject();
                if (objectArray.length != 5) {
                    return;
                }
                if (!ObjectUtilities.equal((Object)string, (Object)objectArray[0])) {
                    return;
                }
                hashMap4 = (HashMap)objectArray[1];
                hashMap3 = (HashMap)objectArray[2];
                hashMap2 = (HashMap)objectArray[3];
                hashMap = (HashMap)objectArray[4];
            }
            finally {
                inputStream.close();
            }
            if (this.isCacheValid(hashMap4)) {
                this.getSeenFiles().putAll(hashMap4);
                this.fontFamilies.putAll(hashMap3);
                this.fullFontNames.putAll(hashMap2);
                this.alternateFamilyNames.putAll(hashMap);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.debug((Object)"Failed to restore the cache: Cache was created by a different version of LibFonts");
        }
        catch (Exception exception) {
            logger.debug((Object)"Non-Fatal: Failed to restore the cache. The cache will be rebuilt.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void storeToCache(String string) {
        File file = this.createStorageLocation();
        if (file == null) {
            return;
        }
        file.mkdirs();
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        File file2 = new File(file, "ttf-fontcache.ser");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                Object[] objectArray = new Object[]{string, this.getSeenFiles(), this.fontFamilies, this.fullFontNames, this.alternateFamilyNames};
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
                objectOutputStream.writeObject(objectArray);
                objectOutputStream.close();
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    logger.debug((Object)"Failed to store cached font data", (Throwable)iOException);
                }
            }
        }
        catch (IOException iOException) {
            logger.debug((Object)"Failed to store cached font data", (Throwable)iOException);
        }
    }

    static {
        logger = LogFactory.getLog(TrueTypeFontRegistry.class);
        FONTPATHFILTER = new FontPathFilter();
    }

    private static class FontPathFilter
    implements FileFilter,
    Serializable {
        protected FontPathFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (!file.canRead()) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            if (StringUtils.endsWithIgnoreCase((String)string, (String)".ttf")) {
                return true;
            }
            if (StringUtils.endsWithIgnoreCase((String)string, (String)".ttc")) {
                return true;
            }
            return StringUtils.endsWithIgnoreCase((String)string, (String)".otf");
        }
    }
}

