/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.Serializable;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

public class TrueTypeFontIdentifier
implements FontIdentifier,
Serializable {
    private String fontSource;
    private String fontName;
    private String fontVariant;
    private int collectionIndex;
    private long offset;

    public TrueTypeFontIdentifier(String string, String string2, String string3, int n, long l) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (string3 == null) {
            throw new NullPointerException();
        }
        this.fontVariant = string3;
        this.fontSource = string;
        this.fontName = string2;
        this.collectionIndex = n;
        this.offset = l;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TrueTypeFontIdentifier trueTypeFontIdentifier = (TrueTypeFontIdentifier)object;
        if (this.collectionIndex != trueTypeFontIdentifier.collectionIndex) {
            return false;
        }
        if (this.offset != trueTypeFontIdentifier.offset) {
            return false;
        }
        if (!this.fontSource.equals(trueTypeFontIdentifier.fontSource)) {
            return false;
        }
        if (!this.fontName.equals(trueTypeFontIdentifier.fontName)) {
            return false;
        }
        return this.fontVariant.equals(trueTypeFontIdentifier.fontVariant);
    }

    @Override
    public int hashCode() {
        int n = this.fontName.hashCode();
        n = 29 * n + this.fontSource.hashCode();
        n = 29 * n + this.fontVariant.hashCode();
        n = 29 * n + this.collectionIndex;
        n = 29 * n + (int)(this.offset ^ this.offset >>> 32);
        return n;
    }

    public String getFontSource() {
        return this.fontSource;
    }

    public String getFontVariant() {
        return this.fontVariant;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getCollectionIndex() {
        return this.collectionIndex;
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public boolean isScalable() {
        return true;
    }

    @Override
    public FontType getFontType() {
        return FontType.OPENTYPE;
    }
}

