/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.fonts.ByteAccessUtilities;
import org.pentaho.reporting.libraries.fonts.io.FileFontDataInputSource;
import org.pentaho.reporting.libraries.fonts.io.FontDataInputSource;
import org.pentaho.reporting.libraries.fonts.truetype.FontHeaderTable;
import org.pentaho.reporting.libraries.fonts.truetype.FontTable;
import org.pentaho.reporting.libraries.fonts.truetype.HorizontalHeaderTable;
import org.pentaho.reporting.libraries.fonts.truetype.NameTable;
import org.pentaho.reporting.libraries.fonts.truetype.OS2Table;
import org.pentaho.reporting.libraries.fonts.truetype.PostscriptInformationTable;

public class TrueTypeFont {
    private static Log logger = LogFactory.getLog(TrueTypeFont.class);
    private long offset;
    private String filename;
    private FontDataInputSource input;
    private transient byte[] readBuffer;
    private TableDirectoryEntry[] directory;
    private TrueTypeFontHeader header;
    private int collectionIndex;

    public TrueTypeFont(FontDataInputSource fontDataInputSource) throws IOException {
        this(fontDataInputSource, 0L, -1);
    }

    public TrueTypeFont(FontDataInputSource fontDataInputSource, long l) throws IOException {
        this(fontDataInputSource, l, -1);
    }

    public TrueTypeFont(FontDataInputSource fontDataInputSource, long l, int n) throws IOException {
        if (l < 0L) {
            throw new IndexOutOfBoundsException();
        }
        this.collectionIndex = n;
        this.offset = l;
        this.input = fontDataInputSource;
        this.filename = fontDataInputSource.getFileName();
        this.header = new TrueTypeFontHeader(this.readFully(l, 12));
        this.directory = this.readTableDirectory();
    }

    public TrueTypeFont(File file) throws IOException {
        this(file, 0L, -1);
    }

    public TrueTypeFont(File file, long l) throws IOException {
        this(file, l, -1);
    }

    public TrueTypeFont(File file, long l, int n) throws IOException {
        this(new FileFontDataInputSource(file), l, n);
    }

    public int getCollectionIndex() {
        return this.collectionIndex;
    }

    private TableDirectoryEntry[] readTableDirectory() throws IOException {
        int n = this.header.getNumTables();
        int n2 = n * 16;
        byte[] byArray = this.readFully(this.offset + 12L, n2);
        TableDirectoryEntry[] tableDirectoryEntryArray = new TableDirectoryEntry[n];
        for (int i = 0; i < this.header.getNumTables(); ++i) {
            int n3 = 16 * i;
            tableDirectoryEntryArray[i] = new TableDirectoryEntry(byArray, n3);
        }
        return tableDirectoryEntryArray;
    }

    protected byte[] readFully(long l, int n) throws IOException {
        if (this.readBuffer == null) {
            this.readBuffer = new byte[Math.max(8192, n)];
        } else if (this.readBuffer.length < n) {
            this.readBuffer = new byte[n];
        }
        this.input.readFullyAt(l, this.readBuffer, n);
        if (this.readBuffer.length - n > 0) {
            Arrays.fill(this.readBuffer, n, this.readBuffer.length, (byte)0);
        }
        return this.readBuffer;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getFilename() {
        return this.filename;
    }

    public FontTable getTable(long l) throws IOException {
        for (TableDirectoryEntry tableDirectoryEntry : this.directory) {
            if (tableDirectoryEntry.getTag() != l) continue;
            FontTable fontTable = tableDirectoryEntry.getTable();
            if (fontTable != null) {
                return fontTable;
            }
            FontTable fontTable2 = this.readTable(tableDirectoryEntry);
            if (fontTable2 == null) {
                return null;
            }
            tableDirectoryEntry.setTable(fontTable2);
            return fontTable2;
        }
        return null;
    }

    protected FontTable readTable(TableDirectoryEntry tableDirectoryEntry) throws IOException {
        if (tableDirectoryEntry.getTag() == 1851878757L) {
            byte[] byArray = this.readFully(tableDirectoryEntry.getOffset(), tableDirectoryEntry.getLength());
            return new NameTable(byArray);
        }
        if (tableDirectoryEntry.getTag() == 1751474532L) {
            byte[] byArray = this.readFully(tableDirectoryEntry.getOffset(), tableDirectoryEntry.getLength());
            return new FontHeaderTable(byArray);
        }
        if (tableDirectoryEntry.getTag() == 1751672161L) {
            byte[] byArray = this.readFully(tableDirectoryEntry.getOffset(), tableDirectoryEntry.getLength());
            return new HorizontalHeaderTable(byArray);
        }
        if (tableDirectoryEntry.getTag() == 1330851634L) {
            FontHeaderTable fontHeaderTable = (FontHeaderTable)this.getTable(1751474532L);
            if (fontHeaderTable == null) {
                logger.warn((Object)("The font '" + this.filename + "' does not have a 'head' table. The font file is not valid."));
                return null;
            }
            byte[] byArray = this.readFully(tableDirectoryEntry.getOffset(), tableDirectoryEntry.getLength());
            return new OS2Table(byArray, fontHeaderTable.getUnitsPerEm());
        }
        if (tableDirectoryEntry.getTag() == 1886352244L) {
            byte[] byArray = this.readFully(tableDirectoryEntry.getOffset(), tableDirectoryEntry.getLength());
            return new PostscriptInformationTable(byArray);
        }
        return null;
    }

    public void dispose() {
        this.input.dispose();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public FontDataInputSource getInputSource() {
        return this.input;
    }

    private static class TableDirectoryEntry {
        public static final int ENTRY_LENGTH = 16;
        private long tag;
        private long checkSum;
        private int offset;
        private int length;
        private FontTable table;

        protected TableDirectoryEntry(byte[] byArray, int n) {
            this.tag = ByteAccessUtilities.readULong(byArray, n);
            this.checkSum = ByteAccessUtilities.readULong(byArray, n + 4);
            this.offset = (int)ByteAccessUtilities.readULong(byArray, n + 8);
            this.length = (int)ByteAccessUtilities.readULong(byArray, n + 12);
        }

        public long getTag() {
            return this.tag;
        }

        public long getCheckSum() {
            return this.checkSum;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public FontTable getTable() {
            return this.table;
        }

        public void setTable(FontTable fontTable) {
            this.table = fontTable;
        }

        public String toString() {
            char c = (char)(this.tag >> 24 & 0xFFL);
            char c2 = (char)(this.tag >> 16 & 0xFFL);
            char c3 = (char)(this.tag >> 8 & 0xFFL);
            char c4 = (char)(this.tag & 0xFFL);
            return "TableDirectoryEntry={" + c + c2 + c3 + c4 + ',' + this.table + '}';
        }
    }

    private static class TrueTypeFontHeader {
        public static final int ENTRY_LENGTH = 12;
        private long version;
        private int numTables;
        private int searchRange;
        private int entrySelector;
        private int rangeShift;

        protected TrueTypeFontHeader(byte[] byArray) {
            this.version = ByteAccessUtilities.readULong(byArray, 0);
            this.numTables = ByteAccessUtilities.readUShort(byArray, 4);
            this.searchRange = ByteAccessUtilities.readUShort(byArray, 6);
            this.entrySelector = ByteAccessUtilities.readUShort(byArray, 8);
            this.rangeShift = ByteAccessUtilities.readUShort(byArray, 10);
        }

        public long getVersion() {
            return this.version;
        }

        public int getNumTables() {
            return this.numTables;
        }

        public int getSearchRange() {
            return this.searchRange;
        }

        public int getEntrySelector() {
            return this.entrySelector;
        }

        public int getRangeShift() {
            return this.rangeShift;
        }
    }
}

