/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import org.pentaho.reporting.libraries.fonts.ByteAccessUtilities;
import org.pentaho.reporting.libraries.fonts.truetype.FontTable;

public class OS2Table
implements FontTable {
    public static final long TABLE_ID = 1330851634L;
    private int version;
    private short xAvgCharWidth;
    private int weightClass;
    private int widthClass;
    private int fsType;
    private short ySubscriptXSize;
    private short ySubscriptYSize;
    private short ySubscriptXOffset;
    private short ySubscriptYOffset;
    private short ySuperscriptXSize;
    private short ySuperscriptYSize;
    private short ySuperscriptXOffset;
    private short ySuperscriptYOffset;
    private short yStrikeoutSize;
    private short yStrikeoutPosition;
    private short familyClass;
    private byte[] panose;
    private byte[] unicodeRange;
    private byte[] vendorId;
    private int fsSelection;
    private int firstCharIndex;
    private int lastCharIndex;
    private int typoAscender;
    private int typoDescender;
    private int typoLineGap;
    private int winAscent;
    private int winDescent;
    private byte[] codepageRange;
    private short xHeight;
    private short capHeight;
    private int defaultChar;
    private int breakChar;
    private int maxContext;
    private static final int TYPE_RESTRICTED_LICENSE = 2;

    public OS2Table(byte[] byArray, int n) {
        this.capHeight = (short)(0.7 * (double)n);
        this.xHeight = (short)(0.5 * (double)n);
        this.breakChar = 32;
        this.version = ByteAccessUtilities.readUShort(byArray, 0);
        if (this.version == 3 || this.version == 2) {
            this.loadVersion2Table(byArray);
        } else if (this.version == 1) {
            this.loadVersion1Table(byArray);
        } else if (this.version == 0) {
            this.loadVersion0Table(byArray);
        }
    }

    private void loadVersion0Table(byte[] byArray) {
        this.xAvgCharWidth = ByteAccessUtilities.readShort(byArray, 2);
        this.weightClass = ByteAccessUtilities.readUShort(byArray, 4);
        this.widthClass = ByteAccessUtilities.readUShort(byArray, 6);
        this.fsType = ByteAccessUtilities.readUShort(byArray, 8);
        this.ySubscriptXSize = ByteAccessUtilities.readShort(byArray, 10);
        this.ySubscriptYSize = ByteAccessUtilities.readShort(byArray, 12);
        this.ySubscriptXOffset = ByteAccessUtilities.readShort(byArray, 14);
        this.ySubscriptYOffset = ByteAccessUtilities.readShort(byArray, 16);
        this.ySuperscriptXSize = ByteAccessUtilities.readShort(byArray, 18);
        this.ySuperscriptYSize = ByteAccessUtilities.readShort(byArray, 20);
        this.ySuperscriptXOffset = ByteAccessUtilities.readShort(byArray, 22);
        this.ySuperscriptYOffset = ByteAccessUtilities.readShort(byArray, 24);
        this.yStrikeoutSize = ByteAccessUtilities.readShort(byArray, 26);
        this.yStrikeoutPosition = ByteAccessUtilities.readShort(byArray, 28);
        this.familyClass = ByteAccessUtilities.readShort(byArray, 30);
        this.panose = ByteAccessUtilities.readBytes(byArray, 32, 10);
        this.unicodeRange = ByteAccessUtilities.readBytes(byArray, 42, 16);
        this.vendorId = ByteAccessUtilities.readBytes(byArray, 58, 4);
        this.fsSelection = ByteAccessUtilities.readUShort(byArray, 62);
        this.firstCharIndex = ByteAccessUtilities.readUShort(byArray, 64);
        this.lastCharIndex = ByteAccessUtilities.readUShort(byArray, 66);
        this.typoAscender = ByteAccessUtilities.readShort(byArray, 68);
        this.typoDescender = ByteAccessUtilities.readShort(byArray, 70);
        this.typoLineGap = ByteAccessUtilities.readShort(byArray, 72);
        this.winAscent = ByteAccessUtilities.readUShort(byArray, 74);
        this.winDescent = ByteAccessUtilities.readUShort(byArray, 76);
    }

    private void loadVersion1Table(byte[] byArray) {
        this.loadVersion0Table(byArray);
        this.codepageRange = ByteAccessUtilities.readBytes(byArray, 78, 8);
    }

    private void loadVersion2Table(byte[] byArray) {
        this.loadVersion1Table(byArray);
        this.xHeight = ByteAccessUtilities.readShort(byArray, 86);
        this.capHeight = ByteAccessUtilities.readShort(byArray, 88);
        this.defaultChar = ByteAccessUtilities.readUShort(byArray, 90);
        this.breakChar = ByteAccessUtilities.readUShort(byArray, 92);
        this.maxContext = ByteAccessUtilities.readUShort(byArray, 94);
    }

    public int getVersion() {
        return this.version;
    }

    public short getxAvgCharWidth() {
        return this.xAvgCharWidth;
    }

    public int getWeightClass() {
        return this.weightClass;
    }

    public int getWidthClass() {
        return this.widthClass;
    }

    public int getFsType() {
        return this.fsType;
    }

    public short getySubscriptXSize() {
        return this.ySubscriptXSize;
    }

    public short getySubscriptYSize() {
        return this.ySubscriptYSize;
    }

    public short getySubscriptXOffset() {
        return this.ySubscriptXOffset;
    }

    public short getySubscriptYOffset() {
        return this.ySubscriptYOffset;
    }

    public short getySuperscriptXSize() {
        return this.ySuperscriptXSize;
    }

    public short getySuperscriptYSize() {
        return this.ySuperscriptYSize;
    }

    public short getySuperscriptXOffset() {
        return this.ySuperscriptXOffset;
    }

    public short getySuperscriptYOffset() {
        return this.ySuperscriptYOffset;
    }

    public short getyStrikeoutSize() {
        return this.yStrikeoutSize;
    }

    public short getyStrikeoutPosition() {
        return this.yStrikeoutPosition;
    }

    public short getsFamilyClass() {
        return this.familyClass;
    }

    public byte[] getPanose() {
        return (byte[])this.panose.clone();
    }

    public boolean isUnicodeRangeSupported(int n) {
        return false;
    }

    public byte[] getVendorId() {
        return (byte[])this.vendorId.clone();
    }

    public int getFsSelection() {
        return this.fsSelection;
    }

    public boolean isBold() {
        return (this.fsSelection & 0x20) == 32;
    }

    public boolean isItalic() {
        return (this.fsSelection & 1) == 1;
    }

    public int getFirstCharIndex() {
        return this.firstCharIndex;
    }

    public int getLastCharIndex() {
        return this.lastCharIndex;
    }

    public int getTypoAscender() {
        return this.typoAscender;
    }

    public int getTypoDescender() {
        return this.typoDescender;
    }

    public int getTypoLineGap() {
        return this.typoLineGap;
    }

    public int getWinAscent() {
        return this.winAscent;
    }

    public int getWinDescent() {
        return this.winDescent;
    }

    public boolean isCodepageSupported(int n) {
        return false;
    }

    public short getxHeight() {
        return this.xHeight;
    }

    public short getCapHeight() {
        return this.capHeight;
    }

    public int getDefaultChar() {
        return this.defaultChar;
    }

    public int getBreakChar() {
        return this.breakChar;
    }

    public int getMaxContext() {
        return this.maxContext;
    }

    public boolean isRestricted() {
        return this.fsType == 2;
    }

    @Override
    public long getName() {
        return 1330851634L;
    }
}

