/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.truetype;

import java.util.TreeSet;
import org.pentaho.reporting.libraries.fonts.ByteAccessUtilities;
import org.pentaho.reporting.libraries.fonts.LanguageCode;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingException;
import org.pentaho.reporting.libraries.fonts.truetype.FontTable;
import org.pentaho.reporting.libraries.fonts.truetype.mappings.PlatformIdentifier;

public class NameTable
implements FontTable {
    public static final int NAME_COPYRIGHT = 0;
    public static final int NAME_FAMILY = 1;
    public static final int NAME_SUBFAMILY = 2;
    public static final int NAME_UNIQUE_SUBFAMILY = 3;
    public static final int NAME_FULLNAME = 4;
    public static final int NAME_VERSION = 5;
    public static final int NAME_POSTSCRIPT = 6;
    public static final int NAME_TRADEMARK = 7;
    public static final int NAME_MANUFACTURER = 8;
    public static final int NAME_DESIGNER = 9;
    public static final int NAME_DESCRIPTION = 10;
    public static final int NAME_VENDOR_URL = 11;
    public static final int NAME_DESIGNER_URL = 12;
    public static final int NAME_LICENCE_DESCRIPTION = 13;
    public static final int NAME_LICENCE_URL = 14;
    public static final int NAME_RESERVED = 15;
    public static final int NAME_PREFERRED_FAMILY = 16;
    public static final int NAME_PREFERRED_SUBFAMILY = 17;
    public static final int NAME_COMPATIBLE_FULL = 18;
    public static final int NAME_SAMPLE_TEXT = 19;
    public static final long TABLE_ID = 1851878757L;
    private int format = 0;
    private int recordCount;
    private int stringOffset;
    private NameRecord[] names;

    public NameTable(byte[] byArray) throws EncodingException {
        this.recordCount = ByteAccessUtilities.readUShort(byArray, 2);
        this.stringOffset = ByteAccessUtilities.readUShort(byArray, 4);
        this.names = new NameRecord[this.recordCount];
        for (int i = 0; i < this.recordCount; ++i) {
            this.names[i] = new NameRecord(byArray, 6 + i * 12, this.stringOffset);
        }
    }

    public String getName(int n, PlatformIdentifier platformIdentifier, int n2, int n3) {
        for (NameRecord nameRecord : this.names) {
            if (!nameRecord.getPlatformId().equals(platformIdentifier) || nameRecord.getPlatformEncodingId() != n2 || nameRecord.getLanguageId() != n3 || nameRecord.getNameId() != n) continue;
            return nameRecord.getName();
        }
        return null;
    }

    public String getName(int n, LanguageCode languageCode) {
        for (NameRecord nameRecord : this.names) {
            if (nameRecord.getNameId() != n || nameRecord.getLanguageId() != languageCode.getCode()) continue;
            return nameRecord.getName();
        }
        return null;
    }

    public int getFormat() {
        return this.format;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public int getStringOffset() {
        return this.stringOffset;
    }

    public NameRecord[] getNameRecords() {
        return (NameRecord[])this.names.clone();
    }

    public NameRecord getNameRecord(int n) {
        return this.names[n];
    }

    public String getPrimaryName(int n) {
        String string = null;
        for (NameRecord nameRecord : this.names) {
            if (nameRecord.getNameId() != n) continue;
            if (nameRecord.getPlatformId().equals(PlatformIdentifier.MICROSOFT) && nameRecord.getLanguageId() == LanguageCode.MicrosoftLanguageCode.ENGLISH_US.getCode()) {
                return nameRecord.getName();
            }
            if (nameRecord.getPlatformId().equals(PlatformIdentifier.MACINTOSH) && nameRecord.getLanguageId() == LanguageCode.MacLanguageCode.ENGLISH.getCode()) {
                return nameRecord.getName();
            }
            if (nameRecord.getPlatformId().equals(PlatformIdentifier.UNICODE)) {
                string = nameRecord.getName();
            }
            if (string == null) continue;
            string = nameRecord.getName();
        }
        return string;
    }

    public String[] getAllNames(int n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (NameRecord nameRecord : this.names) {
            if (nameRecord.getNameId() != n) continue;
            treeSet.add(nameRecord.getName());
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    @Override
    public long getName() {
        return 1851878757L;
    }

    public static class NameRecord {
        private PlatformIdentifier platformId;
        private int platformEncodingId;
        private int languageId;
        private int nameId;
        private String name;

        public NameRecord(byte[] byArray, int n, int n2) throws EncodingException {
            this.platformId = PlatformIdentifier.getIdentifier(ByteAccessUtilities.readUShort(byArray, n));
            this.platformEncodingId = ByteAccessUtilities.readUShort(byArray, n + 2);
            this.languageId = ByteAccessUtilities.readUShort(byArray, n + 4);
            this.nameId = ByteAccessUtilities.readUShort(byArray, n + 6);
            int n3 = ByteAccessUtilities.readUShort(byArray, n + 8);
            int n4 = ByteAccessUtilities.readUShort(byArray, n + 10);
            this.name = ByteAccessUtilities.readString(byArray, n2 + n4, n3, this.platformId.getEncoding(this.platformEncodingId, this.languageId));
        }

        public PlatformIdentifier getPlatformId() {
            return this.platformId;
        }

        public int getPlatformEncodingId() {
            return this.platformEncodingId;
        }

        public int getLanguageId() {
            return this.languageId;
        }

        public int getNameId() {
            return this.nameId;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NameRecord={PlattformID=");
            stringBuffer.append(this.platformId);
            stringBuffer.append(", EncodingID=");
            stringBuffer.append(this.platformEncodingId);
            stringBuffer.append(", LanguageID=");
            stringBuffer.append(this.languageId);
            stringBuffer.append(", NameID=");
            stringBuffer.append(this.nameId);
            stringBuffer.append(", Name=");
            stringBuffer.append(this.name);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }
}

