/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.tools;

import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.afm.AfmFontRegistry;
import org.pentaho.reporting.libraries.fonts.pfm.PfmFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontSource;

public class ListFonts {
    private ListFonts() {
    }

    private static void printRecord(FontRecord fontRecord) {
        if (fontRecord == null) {
            System.out.println("  - (there is no font defined for that style and family.)");
            return;
        }
        if (fontRecord instanceof FontSource) {
            FontSource fontSource = (FontSource)fontRecord;
            System.out.println("  " + fontRecord.getFamily().getFamilyName() + " italics:" + fontRecord.isItalic() + " oblique:" + fontRecord.isOblique() + " bold: " + fontRecord.isBold() + ' ' + fontSource.getFontSource());
        } else {
            System.out.println("  " + fontRecord.getFamily().getFamilyName() + " italics:" + fontRecord.isItalic() + " oblique:" + fontRecord.isOblique() + " bold: " + fontRecord.isBold());
        }
    }

    public static void main(String[] stringArray) {
        LibFontBoot.getInstance().start();
        ListFonts.listFontS(new AfmFontRegistry());
        ListFonts.listFontS(new PfmFontRegistry());
    }

    private static void listFontS(FontRegistry fontRegistry) {
        fontRegistry.initialize();
        String[] stringArray = fontRegistry.getRegisteredFamilies();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            FontFamily fontFamily = fontRegistry.getFontFamily(string);
            ListFonts.printRecord(fontFamily.getFontRecord(false, false));
            ListFonts.printRecord(fontFamily.getFontRecord(true, false));
            ListFonts.printRecord(fontFamily.getFontRecord(false, true));
            ListFonts.printRecord(fontFamily.getFontRecord(true, true));
        }
    }
}

