/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.tools;

import java.io.Serializable;
import java.util.Arrays;

public class ByteTable
implements Serializable {
    private static final long serialVersionUID = -276004279213053063L;
    private int rows;
    private int columns;
    private byte[][] data;

    public ByteTable(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("Increment must be positive.");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Increment must be positive.");
        }
        this.rows = n;
        this.columns = n2;
        this.data = new byte[n][];
    }

    public void ensureCapacity(int n, int n2) {
        if (n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("Row is invalid. " + n);
        }
        if (n2 < 0 || n2 >= this.columns) {
            throw new IndexOutOfBoundsException("Column is invalid. " + n2);
        }
        byte[] byArray = this.data[n];
        if (byArray == null) {
            this.data[n] = new byte[Math.max(n2 + 1, this.columns)];
        }
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    public byte getByte(int n, int n2, byte by) {
        if (n < this.data.length) {
            byte[] byArray = this.data[n];
            if (byArray == null) {
                return by;
            }
            if (n2 < byArray.length) {
                return byArray[n2];
            }
        }
        return by;
    }

    public void setByte(int n, int n2, byte by) {
        this.ensureCapacity(n, n2);
        this.data[n][n2] = by;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof ByteTable)) {
            return false;
        }
        ByteTable byteTable = (ByteTable)object;
        if (this.getRowCount() != byteTable.getRowCount()) {
            return false;
        }
        if (this.getColumnCount() != byteTable.getColumnCount()) {
            return false;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (this.getByte(i, j, (byte)-1) == byteTable.getByte(i, j, (byte)-1)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = this.rows;
        n = 29 * n + this.columns;
        return n;
    }

    public void clear(byte by) {
        this.rows = 0;
        this.columns = 0;
        int n = this.data.length;
        for (int i = 0; i < n; ++i) {
            if (this.data[i] == null) continue;
            Arrays.fill(this.data[i], by);
        }
    }

    protected byte[][] getData() {
        return this.data;
    }
}

