/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.text.whitespace;

import org.pentaho.reporting.libraries.fonts.text.whitespace.WhiteSpaceFilter;

public class PreserveBreaksWhiteSpaceFilter
implements WhiteSpaceFilter {
    private boolean collapse;

    @Override
    public void reset() {
        this.collapse = false;
    }

    @Override
    public int filter(int n) {
        if (this.isLinebreak(n)) {
            this.collapse = true;
            return n;
        }
        if (this.isWhitespace(n)) {
            if (this.collapse) {
                return -1;
            }
            this.collapse = true;
            return 32;
        }
        if (n == Integer.MIN_VALUE) {
            this.collapse = true;
            return -1;
        }
        if (n == Integer.MAX_VALUE) {
            return -1;
        }
        this.collapse = false;
        return n;
    }

    private boolean isWhitespace(int n) {
        char c = (char)(n & 0xFFFF);
        return Character.isWhitespace(c);
    }

    protected boolean isLinebreak(int n) {
        return n == 10 || n == 13;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

