/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.text.font;

import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.text.font.FontSizeProducer;
import org.pentaho.reporting.libraries.fonts.text.font.GlyphMetrics;
import org.pentaho.reporting.libraries.fonts.tools.StrictGeomUtility;

public class StaticFontSizeProducer
implements FontSizeProducer {
    private int maxWidth;
    private int maxHeight;
    private int baseLine;

    public StaticFontSizeProducer(FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            throw new NullPointerException();
        }
        this.maxHeight = (int)(Integer.MAX_VALUE & StrictGeomUtility.toInternalValue(fontMetrics.getMaxHeight()));
        this.maxWidth = (int)(Integer.MAX_VALUE & StrictGeomUtility.toInternalValue(fontMetrics.getMaxCharAdvance()));
        this.baseLine = (int)(Integer.MAX_VALUE & StrictGeomUtility.toInternalValue(fontMetrics.getMaxHeight() - fontMetrics.getMaxDescent()));
    }

    public StaticFontSizeProducer(int n, int n2, int n3) {
        this.maxWidth = n;
        this.maxHeight = n2;
        this.baseLine = n3;
    }

    @Override
    public GlyphMetrics getCharacterSize(int n, GlyphMetrics glyphMetrics) {
        if (glyphMetrics == null) {
            GlyphMetrics glyphMetrics2 = new GlyphMetrics();
            glyphMetrics2.setWidth(this.maxWidth);
            glyphMetrics2.setHeight(this.maxHeight);
            glyphMetrics2.setBaselinePosition(this.baseLine);
            return glyphMetrics2;
        }
        glyphMetrics.setWidth(this.maxWidth);
        glyphMetrics.setHeight(this.maxHeight);
        glyphMetrics.setBaselinePosition(this.baseLine);
        return glyphMetrics;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

