/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.fonts.tools.ByteTable;

public final class GraphemeClassifier {
    private static Log logger = LogFactory.getLog(GraphemeClassifier.class);
    public static final int OTHER = 0;
    public static final int CR = 1;
    public static final int LF = 2;
    public static final int CONTROL = 3;
    public static final int EXTEND = 4;
    public static final int L = 8;
    public static final int LV = 24;
    public static final int V = 56;
    public static final int T = 104;
    public static final int LVT = 72;
    public static final int ANY_HANGUL_MASK = 8;
    public static final int V_OR_LV_MASK = 24;
    public static final int V_OR_T_MASK = 40;
    public static final int LVT_OR_T_MASK = 72;
    private ByteTable classificationData;
    private static GraphemeClassifier classifier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphemeClassifier() {
        InputStream inputStream = this.getClass().getResourceAsStream("/org/pentaho/reporting/libraries/fonts/text/generated/grapheme-classification.ser");
        if (inputStream != null) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                this.classificationData = (ByteTable)objectInputStream.readObject();
                objectInputStream.close();
                inputStream = null;
            }
            catch (Exception exception) {
                logger.warn((Object)"Unable to load the pre-generated classification data.", (Throwable)exception);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public int getGraphemeClassification(int n) {
        if (this.classificationData != null) {
            int n2 = n >> 8;
            int n3 = n & 0xFF;
            return this.classificationData.getByte(n2, n3, (byte)0);
        }
        if (n == 13) {
            return 1;
        }
        if (n == 10) {
            return 2;
        }
        return 0;
    }

    public static synchronized GraphemeClassifier getClassifier() {
        if (classifier == null) {
            classifier = new GraphemeClassifier();
        }
        return classifier;
    }
}

