/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.registry;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class FontFileRecord
implements Serializable {
    private long lastAccessTime;
    private long fileSize;
    private String filename;

    public FontFileRecord(File file) throws IOException {
        this(file.getCanonicalPath(), file.length(), file.lastModified());
    }

    public FontFileRecord(String string, long l, long l2) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.filename = string;
        this.fileSize = l;
        this.lastAccessTime = l2;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FontFileRecord fontFileRecord = (FontFileRecord)object;
        if (this.fileSize != fontFileRecord.fileSize) {
            return false;
        }
        if (this.lastAccessTime != fontFileRecord.lastAccessTime) {
            return false;
        }
        return this.filename.equals(fontFileRecord.filename);
    }

    public int hashCode() {
        int n = (int)(this.lastAccessTime ^ this.lastAccessTime >>> 32);
        n = 29 * n + (int)(this.fileSize ^ this.fileSize >>> 32);
        n = 29 * n + this.filename.hashCode();
        return n;
    }
}

