/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.registry;

import org.pentaho.reporting.libraries.fonts.registry.BaselineInfo;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.tools.StrictGeomUtility;

public class EmptyFontMetrics
implements FontMetrics {
    private long baseSize;
    private long baseWidth;

    public EmptyFontMetrics(double d, double d2) {
        this.baseSize = StrictGeomUtility.toInternalValue(d2);
        this.baseWidth = StrictGeomUtility.toInternalValue(d);
    }

    public EmptyFontMetrics(long l, long l2) {
        this.baseWidth = l;
        this.baseSize = l2;
    }

    @Override
    public boolean isUniformFontMetrics() {
        return true;
    }

    @Override
    public long getAscent() {
        return StrictGeomUtility.toInternalValue((double)this.baseSize * 0.7);
    }

    @Override
    public long getDescent() {
        return StrictGeomUtility.toInternalValue((double)this.baseSize * 0.3);
    }

    @Override
    public long getLeading() {
        return 0L;
    }

    @Override
    public long getXHeight() {
        return StrictGeomUtility.toInternalValue((double)this.baseSize * 0.5);
    }

    @Override
    public long getOverlinePosition() {
        return this.getLeading() - Math.max(1000L, this.baseSize / 20L);
    }

    @Override
    public long getUnderlinePosition() {
        return this.getAscent() + Math.max(1000L, this.baseSize / 20L);
    }

    @Override
    public long getStrikeThroughPosition() {
        return StrictGeomUtility.toInternalValue((double)this.getXHeight() * 0.5);
    }

    @Override
    public long getMaxAscent() {
        return this.getAscent();
    }

    @Override
    public long getMaxDescent() {
        return this.getDescent();
    }

    @Override
    public long getMaxHeight() {
        return this.baseSize;
    }

    @Override
    public long getMaxCharAdvance() {
        return this.baseWidth;
    }

    @Override
    public long getCharWidth(int n) {
        return this.baseWidth;
    }

    @Override
    public long getKerning(int n, int n2) {
        return 0L;
    }

    @Override
    public BaselineInfo getBaselines(int n, BaselineInfo baselineInfo) {
        if (baselineInfo == null) {
            baselineInfo = new BaselineInfo();
        }
        long l = this.getMaxAscent();
        baselineInfo.setBaseline(1, l - this.getXHeight());
        baselineInfo.setBaseline(5, this.getMaxHeight());
        baselineInfo.setBaseline(3, l / 2L);
        baselineInfo.setBaseline(4, l);
        baselineInfo.setBaseline(2, l / 2L);
        baselineInfo.setBaseline(0, l - this.getXHeight());
        baselineInfo.setDominantBaseline(4);
        return baselineInfo;
    }

    @Override
    public long getItalicAngle() {
        return 0L;
    }
}

