/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.registry;

import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.fonts.cache.FirstLevelFontCache;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontKey;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class DefaultFontStorage
implements FontStorage {
    private FirstLevelFontCache knownMetrics;
    private FontRegistry registry;
    private FontMetricsFactory metricsFactory;
    private FontKey lookupKey;
    private int hits;
    private int misses;

    public DefaultFontStorage(FontRegistry fontRegistry) {
        this.knownMetrics = new FirstLevelFontCache(fontRegistry.getSecondLevelCache());
        this.registry = fontRegistry;
        this.metricsFactory = fontRegistry.createMetricsFactory();
        this.lookupKey = new FontKey();
    }

    @Override
    public FontRegistry getFontRegistry() {
        return this.registry;
    }

    @Override
    public FontMetrics getFontMetrics(FontIdentifier fontIdentifier, FontContext fontContext) {
        if (fontIdentifier == null) {
            throw new NullPointerException();
        }
        if (fontContext == null) {
            throw new NullPointerException();
        }
        this.lookupKey.setAliased(fontContext.isAntiAliased());
        this.lookupKey.setFontSize(fontContext.getFontSize());
        this.lookupKey.setIdentifier(fontIdentifier);
        this.lookupKey.setFractional(fontContext.isFractionalMetrics());
        FontMetrics fontMetrics = this.knownMetrics.getFontMetrics(this.lookupKey);
        if (fontMetrics != null) {
            ++this.hits;
            return fontMetrics;
        }
        ++this.misses;
        FontKey fontKey = new FontKey(fontIdentifier, fontContext.isAntiAliased(), fontContext.isFractionalMetrics(), fontContext.getFontSize());
        FontMetrics fontMetrics2 = this.metricsFactory.createMetrics(fontIdentifier, fontContext);
        this.knownMetrics.putFontMetrics(fontKey, fontMetrics2);
        return fontMetrics2;
    }

    @Override
    public void commit() {
        DebugLog.log((Object)("Font-Storage: hits=" + this.hits + ", misses=" + this.misses));
        this.knownMetrics.commit();
    }
}

