/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.pfm;

import org.pentaho.reporting.libraries.fonts.pfm.PfmFont;
import org.pentaho.reporting.libraries.fonts.pfm.PfmFontHeader;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontSource;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

public class PfmFontRecord
implements FontSource,
FontIdentifier {
    private DefaultFontFamily fontFamily;
    private boolean bold;
    private boolean italic;
    private String fontFile;
    private boolean embeddable;

    public PfmFontRecord(PfmFont pfmFont, DefaultFontFamily defaultFontFamily) {
        this.embeddable = pfmFont.isEmbeddable();
        this.fontFile = pfmFont.getFilename();
        this.fontFamily = defaultFontFamily;
        PfmFontHeader pfmFontHeader = pfmFont.getHeader();
        this.bold = pfmFontHeader.getWeight() > 400;
        this.italic = pfmFontHeader.isItalic();
    }

    @Override
    public FontFamily getFamily() {
        return this.fontFamily;
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    @Override
    public boolean isItalic() {
        return this.italic;
    }

    @Override
    public boolean isOblique() {
        return false;
    }

    @Override
    public FontIdentifier getIdentifier() {
        return this;
    }

    @Override
    public String getFontSource() {
        return this.fontFile;
    }

    @Override
    public boolean isEmbeddable() {
        return this.embeddable;
    }

    @Override
    public boolean isScalable() {
        return true;
    }

    @Override
    public FontType getFontType() {
        return FontType.PFM;
    }
}

