/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.pfm;

import org.pentaho.reporting.libraries.fonts.LEByteAccessUtilities;

public class PfmFontHeader {
    public static final int LENGTH = 117;
    private short version;
    private long size;
    private short type;
    private short point;
    private short vertRes;
    private short horizRes;
    private short ascent;
    private short internalLeading;
    private short externalLeading;
    private boolean italic;
    private boolean underline;
    private boolean strikeout;
    private short weight;
    private byte charset;
    private short pixelWidth;
    private short pixelHeight;
    private byte pitchAndFamily;
    private short avgWidth;
    private short maxWidth;
    private short firstChar;
    private short lastChar;
    private short defaultChar;
    private short breakChar;
    private short widthBytes;
    private int devicePtr;
    private int facePtr;

    public PfmFontHeader(byte[] byArray) {
        this.version = LEByteAccessUtilities.readShort(byArray, 0);
        this.size = LEByteAccessUtilities.readULong(byArray, 2);
        this.type = LEByteAccessUtilities.readShort(byArray, 66);
        this.point = LEByteAccessUtilities.readShort(byArray, 68);
        this.vertRes = LEByteAccessUtilities.readShort(byArray, 70);
        this.horizRes = LEByteAccessUtilities.readShort(byArray, 72);
        this.ascent = LEByteAccessUtilities.readShort(byArray, 74);
        this.internalLeading = LEByteAccessUtilities.readShort(byArray, 76);
        this.externalLeading = LEByteAccessUtilities.readShort(byArray, 78);
        this.italic = byArray[80] != 0;
        this.underline = byArray[81] != 0;
        this.strikeout = byArray[82] != 0;
        this.weight = LEByteAccessUtilities.readShort(byArray, 83);
        this.charset = byArray[85];
        this.pixelWidth = LEByteAccessUtilities.readShort(byArray, 86);
        this.pixelHeight = LEByteAccessUtilities.readShort(byArray, 88);
        this.pitchAndFamily = byArray[90];
        this.avgWidth = LEByteAccessUtilities.readShort(byArray, 91);
        this.maxWidth = LEByteAccessUtilities.readShort(byArray, 93);
        this.firstChar = (short)(0xFF & byArray[95]);
        this.lastChar = (short)(0xFF & byArray[96]);
        this.defaultChar = (short)(0xFF & byArray[97]);
        this.breakChar = (short)(0xFF & byArray[98]);
        this.widthBytes = LEByteAccessUtilities.readShort(byArray, 99);
        this.devicePtr = LEByteAccessUtilities.readLong(byArray, 101);
        this.facePtr = LEByteAccessUtilities.readLong(byArray, 105);
    }

    public int getDevicePtr() {
        return this.devicePtr;
    }

    public int getFacePtr() {
        return this.facePtr;
    }

    public short getVersion() {
        return this.version;
    }

    public long getSize() {
        return this.size;
    }

    public short getType() {
        return this.type;
    }

    public short getPoint() {
        return this.point;
    }

    public short getVertRes() {
        return this.vertRes;
    }

    public short getHorizRes() {
        return this.horizRes;
    }

    public short getAscent() {
        return this.ascent;
    }

    public short getInternalLeading() {
        return this.internalLeading;
    }

    public short getExternalLeading() {
        return this.externalLeading;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public boolean isStrikeout() {
        return this.strikeout;
    }

    public short getWeight() {
        return this.weight;
    }

    public byte getCharset() {
        return this.charset;
    }

    public short getPixelWidth() {
        return this.pixelWidth;
    }

    public short getPixelHeight() {
        return this.pixelHeight;
    }

    public byte getPitchAndFamily() {
        return this.pitchAndFamily;
    }

    public short getAvgWidth() {
        return this.avgWidth;
    }

    public short getMaxWidth() {
        return this.maxWidth;
    }

    public short getFirstChar() {
        return this.firstChar;
    }

    public short getLastChar() {
        return this.lastChar;
    }

    public short getDefaultChar() {
        return this.defaultChar;
    }

    public short getBreakChar() {
        return this.breakChar;
    }

    public short getWidthBytes() {
        return this.widthBytes;
    }

    public String getEncoding() {
        switch (this.charset) {
            case 128: {
                return "SJIS";
            }
            case 129: {
                return "EUC_KR";
            }
            case 134: {
                return "GBK";
            }
            case 136: {
                return "Big5";
            }
        }
        return "Cp1252";
    }
}

