/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.monospace;

import org.pentaho.reporting.libraries.fonts.monospace.MonospaceFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

public class MonospaceFontRecord
implements FontRecord,
FontIdentifier {
    private MonospaceFontFamily fontFamily;
    private boolean bold;
    private boolean italics;

    public MonospaceFontRecord(MonospaceFontFamily monospaceFontFamily, boolean bl, boolean bl2) {
        if (monospaceFontFamily == null) {
            throw new NullPointerException();
        }
        this.fontFamily = monospaceFontFamily;
        this.bold = bl;
        this.italics = bl2;
    }

    @Override
    public FontFamily getFamily() {
        return this.fontFamily;
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    @Override
    public boolean isItalic() {
        return false;
    }

    @Override
    public boolean isOblique() {
        return this.italics;
    }

    @Override
    public boolean isScalable() {
        return false;
    }

    @Override
    public FontType getFontType() {
        return FontType.MONOSPACE;
    }

    @Override
    public FontIdentifier getIdentifier() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MonospaceFontRecord monospaceFontRecord = (MonospaceFontRecord)object;
        if (this.bold != monospaceFontRecord.bold) {
            return false;
        }
        if (this.italics != monospaceFontRecord.italics) {
            return false;
        }
        return this.fontFamily.equals(monospaceFontRecord.fontFamily);
    }

    @Override
    public int hashCode() {
        int n = this.fontFamily.hashCode();
        n = 29 * n + (this.bold ? 1 : 0);
        n = 29 * n + (this.italics ? 1 : 0);
        return n;
    }
}

