/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.monospace;

import org.pentaho.reporting.libraries.fonts.registry.BaselineInfo;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;

public class MonospaceFontMetrics
implements FontMetrics {
    private static final long MICRO_DOTS_PER_INCH = 72000L;
    private long charHeight;
    private long charWidth;

    public MonospaceFontMetrics(float f, float f2) {
        this.charHeight = (long)(72000.0f / f2);
        this.charWidth = (long)(72000.0f / f);
    }

    @Override
    public boolean isUniformFontMetrics() {
        return true;
    }

    @Override
    public long getAscent() {
        return (long)(0.7 * (double)this.charHeight);
    }

    @Override
    public long getDescent() {
        return (long)(0.3 * (double)this.charHeight);
    }

    @Override
    public long getLeading() {
        return 0L;
    }

    @Override
    public long getXHeight() {
        return (long)(0.5 * (double)this.charHeight);
    }

    @Override
    public long getOverlinePosition() {
        return this.getLeading() - Math.max(1000L, this.charHeight / 20L);
    }

    @Override
    public long getUnderlinePosition() {
        return this.getAscent() + Math.max(1000L, this.charHeight / 20L);
    }

    @Override
    public long getStrikeThroughPosition() {
        return (long)(0.5 * (double)this.getXHeight());
    }

    @Override
    public long getMaxAscent() {
        return this.getAscent();
    }

    @Override
    public long getMaxDescent() {
        return this.getDescent();
    }

    @Override
    public long getMaxHeight() {
        return this.charHeight;
    }

    @Override
    public long getMaxCharAdvance() {
        return this.charWidth;
    }

    @Override
    public long getCharWidth(int n) {
        return this.charWidth;
    }

    @Override
    public long getKerning(int n, int n2) {
        return 0L;
    }

    @Override
    public long getItalicAngle() {
        return 0L;
    }

    @Override
    public BaselineInfo getBaselines(int n, BaselineInfo baselineInfo) {
        if (baselineInfo == null) {
            baselineInfo = new BaselineInfo();
        }
        baselineInfo.setBaseline(0, 0L);
        baselineInfo.setBaseline(1, this.charHeight / 2L);
        baselineInfo.setBaseline(2, this.charHeight / 2L);
        baselineInfo.setBaseline(3, this.charHeight / 2L);
        baselineInfo.setBaseline(4, this.getMaxAscent());
        baselineInfo.setBaseline(5, this.getMaxHeight());
        return baselineInfo;
    }
}

