/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.merge;

import java.util.HashMap;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.fonts.cache.FirstLevelFontCache;
import org.pentaho.reporting.libraries.fonts.merge.CompoundFontIdentifier;
import org.pentaho.reporting.libraries.fonts.merge.CompoundFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontKey;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class CompoundFontStorage
implements FontStorage {
    private CompoundFontRegistry fontRegistry = new CompoundFontRegistry();
    private HashMap metricsFactories = new HashMap();
    private FirstLevelFontCache firstLevelFontCache = new FirstLevelFontCache(this.fontRegistry.getSecondLevelCache());
    private FontKey lookupKey = new FontKey();
    private int hits;
    private int misses;

    public void addRegistry(FontRegistry fontRegistry) {
        this.fontRegistry.addRegistry(fontRegistry);
    }

    @Override
    public FontRegistry getFontRegistry() {
        return this.fontRegistry;
    }

    @Override
    public FontMetrics getFontMetrics(FontIdentifier fontIdentifier, FontContext fontContext) {
        if (fontIdentifier == null) {
            throw new NullPointerException();
        }
        if (fontContext == null) {
            throw new NullPointerException();
        }
        this.lookupKey.setAliased(fontContext.isAntiAliased());
        this.lookupKey.setFontSize(fontContext.getFontSize());
        this.lookupKey.setIdentifier(fontIdentifier);
        this.lookupKey.setFractional(fontContext.isFractionalMetrics());
        FontMetrics fontMetrics = this.firstLevelFontCache.getFontMetrics(this.lookupKey);
        if (fontMetrics != null) {
            ++this.hits;
            return fontMetrics;
        }
        CompoundFontIdentifier compoundFontIdentifier = (CompoundFontIdentifier)fontIdentifier;
        FontRegistry fontRegistry = compoundFontIdentifier.getRegistry();
        FontMetricsFactory fontMetricsFactory = (FontMetricsFactory)this.metricsFactories.get(fontRegistry);
        if (fontMetricsFactory == null) {
            fontMetricsFactory = fontRegistry.createMetricsFactory();
            this.metricsFactories.put(fontRegistry, fontMetricsFactory);
        }
        ++this.misses;
        FontKey fontKey = new FontKey(fontIdentifier, fontContext.isAntiAliased(), fontContext.isFractionalMetrics(), fontContext.getFontSize());
        FontMetrics fontMetrics2 = fontMetricsFactory.createMetrics(compoundFontIdentifier.getIdentifier(), fontContext);
        this.firstLevelFontCache.putFontMetrics(fontKey, fontMetrics2);
        return fontMetrics2;
    }

    @Override
    public void commit() {
        DebugLog.log((Object)("Font-Storage: hits=" + this.hits + ", misses=" + this.misses));
        this.firstLevelFontCache.commit();
    }
}

