/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.io;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.pentaho.reporting.libraries.fonts.io.FontDataInputSource;

public class FileFontDataInputSource
implements FontDataInputSource {
    private File file;
    private RandomAccessFile fileReader;
    private long lastPosition;

    public FileFontDataInputSource(File file) throws IOException {
        this.file = file;
        this.fileReader = new RandomAccessFile(file, "r");
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public void readFullyAt(long l, byte[] byArray, int n) throws IOException {
        if (this.fileReader == null) {
            this.fileReader = new RandomAccessFile(this.file, "r");
            if (l > this.fileReader.length()) {
                throw new EOFException("Given position is beyond the end of the file.");
            }
            this.fileReader.seek(l);
        } else {
            if (l > this.fileReader.length()) {
                throw new EOFException("Given position is beyond the end of the file.");
            }
            if (l != this.lastPosition) {
                this.fileReader.seek(l);
            }
        }
        try {
            this.fileReader.readFully(byArray, 0, n);
            this.lastPosition = l + (long)n;
        }
        catch (IOException iOException) {
            this.lastPosition = -1L;
            throw iOException;
        }
    }

    public int readAt(long l, byte[] byArray, int n, int n2) throws IOException {
        if (this.fileReader == null) {
            this.fileReader = new RandomAccessFile(this.file, "r");
            if (l > this.fileReader.length()) {
                return 0;
            }
            this.fileReader.seek(l);
        } else {
            if (l > this.fileReader.length()) {
                return 0;
            }
            if (l != this.lastPosition) {
                this.fileReader.seek(l);
            }
        }
        try {
            int n3 = (int)Math.min((long)n2, this.fileReader.length() - l);
            this.fileReader.readFully(byArray, n, n3);
            this.lastPosition = l + (long)n3;
            return n3;
        }
        catch (IOException iOException) {
            this.lastPosition = -1L;
            throw iOException;
        }
    }

    @Override
    public int readAt(long l) throws IOException {
        if (this.fileReader == null) {
            this.fileReader = new RandomAccessFile(this.file, "r");
            this.fileReader.seek(l);
        } else if (l != this.lastPosition) {
            this.fileReader.seek(l);
        }
        int n = this.fileReader.read();
        if (n == -1) {
            return -1;
        }
        this.lastPosition = l + 1L;
        return n;
    }

    @Override
    public void dispose() {
        if (this.fileReader == null) {
            return;
        }
        try {
            this.fileReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileReader = null;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getFileName() {
        return this.file.getPath();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FileFontDataInputSource fileFontDataInputSource = (FileFontDataInputSource)object;
        return this.file.equals(fileFontDataInputSource.file);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }
}

