/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding.manual;

import java.util.Locale;
import org.pentaho.reporting.libraries.fonts.encoding.ByteBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.ByteStream;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointStream;
import org.pentaho.reporting.libraries.fonts.encoding.ComplexEncoding;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingErrorType;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingException;

public class Utf16LE
implements ComplexEncoding {
    public static final int MAX_CHAR = 1114109;
    private static Utf16LE instance;

    public static synchronized Utf16LE getInstance() {
        if (instance == null) {
            instance = new Utf16LE();
        }
        return instance;
    }

    @Override
    public String getName() {
        return "UTF-16LE";
    }

    @Override
    public String getName(Locale locale) {
        return "UTF-16LE";
    }

    @Override
    public boolean isUnicodeCharacterSupported(int n) {
        return n > 0 && n < 1114109 && (n & 0xFFFFF800) == 55296;
    }

    @Override
    public ByteBuffer encode(CodePointBuffer codePointBuffer, ByteBuffer byteBuffer) {
        int n = codePointBuffer.getLength();
        if (byteBuffer == null) {
            byteBuffer = new ByteBuffer(n * 2);
        } else if (byteBuffer.getLength() * 2 < n) {
            byteBuffer.ensureSize(n * 2);
        }
        ByteStream byteStream = new ByteStream(byteBuffer, n);
        int[] nArray = codePointBuffer.getData();
        int n2 = codePointBuffer.getCursor();
        for (int i = codePointBuffer.getOffset(); i < n2; ++i) {
            int n3 = nArray[i];
            if (n3 < 0 || n3 > 1114109) continue;
            if (n3 <= 65535) {
                if (n3 >= 55296 && n3 <= 57343) continue;
                byteStream.put((byte)((n3 & 0xFF00) >> 8));
                byteStream.put((byte)(n3 & 0xFF));
                continue;
            }
            int n4 = n3 - 65536;
            int n5 = 0xD800 | (n4 & 0xFFC00) >> 10;
            byteStream.put((byte)((n5 & 0xFF00) >> 8));
            byteStream.put((byte)(n5 & 0xFF));
            int n6 = 0xDC00 | n4 & 0x3FF;
            byteStream.put((byte)((n6 & 0xFF00) >> 8));
            byteStream.put((byte)(n6 & 0xFF));
        }
        byteStream.close();
        return byteBuffer;
    }

    @Override
    public CodePointBuffer decode(ByteBuffer byteBuffer, CodePointBuffer codePointBuffer) {
        int n = byteBuffer.getLength();
        if (codePointBuffer == null) {
            codePointBuffer = new CodePointBuffer(n / 2);
        } else if (codePointBuffer.getLength() / 2 < n) {
            codePointBuffer.ensureSize(n / 2);
        }
        int[] nArray = codePointBuffer.getData();
        ByteStream byteStream = new ByteStream(byteBuffer, 10);
        int n2 = codePointBuffer.getOffset();
        while (byteStream.getReadSize() >= 2) {
            int n3 = byteStream.get() & 0xFF;
            int n4 = byteStream.get() & 0xFF;
            if ((n3 & 0xFC) == 216) {
                if (byteStream.getReadSize() < 2) break;
                int n5 = byteStream.get() & 0xFF;
                int n6 = byteStream.get() & 0xFF;
                if ((n5 & 0xFC) != 220) continue;
                int n7 = n6;
                n7 |= (n5 & 3) << 8;
                n7 |= n4 << 10;
                nArray[n2] = (n7 |= (n3 & 3) << 18) + 65536;
                ++n2;
                continue;
            }
            if ((n3 & 0xFC) == 220) continue;
            nArray[n2] = n3 << 8 | n4;
            ++n2;
        }
        codePointBuffer.setCursor(n2);
        return codePointBuffer;
    }

    @Override
    public ByteBuffer encode(CodePointBuffer codePointBuffer, ByteBuffer byteBuffer, EncodingErrorType encodingErrorType) throws EncodingException {
        return this.encode(codePointBuffer, byteBuffer);
    }

    @Override
    public CodePointBuffer decode(ByteBuffer byteBuffer, CodePointBuffer codePointBuffer, EncodingErrorType encodingErrorType) throws EncodingException {
        return this.decode(byteBuffer, codePointBuffer);
    }

    @Override
    public boolean isEncodingSupported() {
        return true;
    }

    public CodePointBuffer decodeString(String string, CodePointBuffer codePointBuffer) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        return this.decode(cArray, 0, n, codePointBuffer);
    }

    public CodePointBuffer decode(char[] cArray, int n, int n2, CodePointBuffer codePointBuffer) {
        if (codePointBuffer == null) {
            codePointBuffer = new CodePointBuffer(n2);
        } else if (codePointBuffer.getLength() < n2) {
            codePointBuffer.ensureSize(n2);
        }
        CodePointStream codePointStream = new CodePointStream(codePointBuffer, 10);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if ((c & 0xFC00) == 55296) {
                if (++i >= n3) break;
                char c2 = cArray[i];
                if ((c2 & 0xFC00) != 56320) continue;
                int n4 = 65536 + (c2 & 0x3FF | (c & 0x3FF) << 10);
                codePointStream.put(n4);
                continue;
            }
            codePointStream.put(c);
        }
        codePointStream.close();
        return codePointBuffer;
    }

    public String encodeString(CodePointBuffer codePointBuffer) {
        StringBuffer stringBuffer = new StringBuffer(codePointBuffer.getLength() * 3 / 2);
        int[] nArray = codePointBuffer.getData();
        int n = codePointBuffer.getCursor();
        for (int i = codePointBuffer.getOffset(); i < n; ++i) {
            int n2 = nArray[i];
            if (n2 < 65536) {
                stringBuffer.append((char)n2);
                continue;
            }
            int n3 = n2 - 65536;
            int n4 = 0xD800 | (n3 & 0xFFC00) >> 10;
            int n5 = 0xDC00 | n3 & 0x3FF;
            stringBuffer.append((char)n4);
            stringBuffer.append((char)n5);
        }
        return stringBuffer.toString();
    }
}

