/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding.generator;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.encoding.External8BitEncodingData;

public class EncodingGenerator {
    private static Log logger = LogFactory.getLog(EncodingGenerator.class);
    private File targetDirectory;
    private DefaultConfiguration propertySet;
    private File sourceDirectory;
    public static final Integer ZERO = new Integer(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncodingGenerator(File file, File file2) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + file);
        }
        if (file2 == null) {
            throw new NullPointerException();
        }
        if (!file2.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + file2);
        }
        if (!file2.canRead()) {
            throw new IllegalArgumentException("Not readable: " + file2);
        }
        this.sourceDirectory = file2;
        this.targetDirectory = file;
        InputStream inputStream = ObjectUtilities.getResourceRelativeAsStream((String)"encodings.properties", EncodingGenerator.class);
        this.propertySet = new DefaultConfiguration();
        try {
            this.propertySet.load(inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    public void generatedFormatA(Properties properties, BufferedReader bufferedReader, OutputStream outputStream) throws IOException {
        Object object;
        Object object2;
        if (bufferedReader == null) {
            throw new NullPointerException();
        }
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (properties == null) {
            throw new NullPointerException();
        }
        Integer[] integerArray = new Integer[256];
        integerArray[0] = ZERO;
        String string = bufferedReader.readLine();
        while (string != null) {
            String string2;
            if (string.length() > 0 && string.charAt(0) == '#') {
                string = bufferedReader.readLine();
                continue;
            }
            object2 = new StringTokenizer(string);
            if (!((StringTokenizer)object2).hasMoreTokens()) {
                string = bufferedReader.readLine();
                continue;
            }
            object = ((StringTokenizer)object2).nextToken().trim();
            if (((String)object).length() == 0) {
                string = bufferedReader.readLine();
                continue;
            }
            Integer n = Integer.decode((String)object);
            if (((StringTokenizer)object2).hasMoreTokens() && !((string2 = ((StringTokenizer)object2).nextToken()).length() > 0 && string2.charAt(0) == '#')) {
                integerArray[n.intValue()] = Integer.decode(string2);
            }
            string = bufferedReader.readLine();
        }
        object2 = new int[256];
        object = new int[256];
        int n = 0;
        int n2 = 0;
        for (int i = 1; i < integerArray.length; ++i) {
            Integer n3 = integerArray[i];
            if (n3 == null) continue;
            Integer n4 = integerArray[n2];
            object[n] = n3 - n4;
            object2[n] = i - n2;
            n2 = i;
            ++n;
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(new External8BitEncodingData((int[])object2, (int[])object));
        objectOutputStream.flush();
    }

    public void generateAll() throws IOException {
        for (String string : this.propertySet.keySet()) {
            if (!string.startsWith("encodings.")) {
                logger.info((Object)"Encoding prefix not found.");
                continue;
            }
            if (!string.endsWith(".Filename")) continue;
            try {
                this.generate(string.substring(0, string.length() - 8));
            }
            catch (Exception exception) {
                logger.warn((Object)("Failed to generate Encoding " + string), (Throwable)exception);
            }
        }
    }

    public void generate(String string) throws IOException {
        String string2 = this.propertySet.getConfigProperty(string + "Filename");
        String string3 = this.propertySet.getConfigProperty(string + "ClassName");
        String string4 = this.propertySet.getConfigProperty(string + "Encoding");
        if (string2 == null) {
            logger.info((Object)("Not generating Encoding: " + string + ": Filename missing"));
            return;
        }
        if (string3 == null) {
            logger.info((Object)("Not generating Encoding: " + string + ": ClassName missing"));
            return;
        }
        if (string4 == null) {
            logger.info((Object)("Not generating Encoding: " + string + ": Encoding missing"));
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("name", string3);
        properties.setProperty("source", string2);
        properties.setProperty("encoding", string4);
        File file = new File(this.sourceDirectory, string3 + ".ser");
        File file2 = new File(this.targetDirectory, string2);
        System.out.println("Generated Java File:  " + file);
        System.out.println("Source Specification: " + file2);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
        this.generatedFormatA(properties, bufferedReader, bufferedOutputStream);
        bufferedReader.close();
        bufferedOutputStream.close();
    }

    public void generatePropertyIndex() throws IOException {
        Object object2;
        Properties properties = new Properties();
        for (Object object2 : this.propertySet.keySet()) {
            if (!((String)object2).startsWith("encodings.")) {
                logger.info((Object)"Encoding prefix not found.");
                continue;
            }
            if (!((String)object2).endsWith(".Filename")) continue;
            try {
                this.generateEncodingEntry(properties, ((String)object2).substring(0, ((String)object2).length() - 8));
            }
            catch (Exception exception) {
                logger.warn((Object)("Failed to generate Encoding " + (String)object2), (Throwable)exception);
            }
        }
        object2 = new File(this.sourceDirectory, "encodings.properties");
        FileOutputStream fileOutputStream = new FileOutputStream((File)object2);
        properties.store(fileOutputStream, "Generated on " + new Date());
        fileOutputStream.close();
    }

    private void generateEncodingEntry(Properties properties, String string) {
        String string2 = this.propertySet.getConfigProperty(string + "ClassName");
        String string3 = this.propertySet.getConfigProperty(string + "Encoding");
        if (string2 == null) {
            logger.info((Object)("Not generating Encoding: " + string + ": ClassName missing"));
            return;
        }
        if (string3 == null) {
            logger.info((Object)("Not generating Encoding: " + string + ": Encoding missing"));
            return;
        }
        properties.setProperty(string3, string2 + ".ser");
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("Need two parameters: EncodingsDirectory and Source-Directory");
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        LibFontBoot.getInstance().start();
        File file = new File(string).getAbsoluteFile();
        File file2 = new File(string2).getAbsoluteFile();
        EncodingGenerator encodingGenerator = new EncodingGenerator(file, file2);
        encodingGenerator.generateAll();
        encodingGenerator.generatePropertyIndex();
    }
}

