/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding;

import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.manual.Utf16LE;

public class CodePointUtilities {
    public static boolean isValidCodePoint(int n) {
        if (n > 0x10FFFF) {
            return false;
        }
        if (n > 57343) {
            return true;
        }
        if (n >= 56320) {
            return false;
        }
        return n >= 0;
    }

    public static int toChars(int n, char[] cArray, int n2) {
        if (n < 65536) {
            if (n2 >= cArray.length) {
                return -1;
            }
            cArray[n2] = n < 0 ? 65535 : (n >= 56320 && n < 57344 ? 65535 : (char)(n & 0xFFFF));
            return 1;
        }
        if (n > 0x10FFFF) {
            if (n2 >= cArray.length) {
                return -1;
            }
            cArray[n2] = 65535;
            return 1;
        }
        if (n2 + 1 >= cArray.length) {
            return -2;
        }
        int n3 = n - 65536;
        int n4 = 0xD800 | (n3 & 0xFFC00) >> 10;
        int n5 = 0xDC00 | n3 & 0x3FF;
        cArray[n2] = (char)n4;
        cArray[n2 + 1] = (char)n5;
        return 2;
    }

    public static int[] charsToCodepoint(String string) {
        CodePointBuffer codePointBuffer = Utf16LE.getInstance().decodeString(string, null);
        return codePointBuffer.getBuffer();
    }

    public static String codepointToChars(int[] nArray) {
        CodePointBuffer codePointBuffer = new CodePointBuffer(nArray);
        codePointBuffer.setCursor(nArray.length);
        return Utf16LE.getInstance().encodeString(codePointBuffer);
    }

    private CodePointUtilities() {
    }
}

