/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.awt;

import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontFamily;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;

public class AWTFontRegistry
implements FontRegistry {
    private static FontCache secondLevelCache;
    private HashMap fontFamilyCache = new HashMap();

    protected static synchronized FontCache internalGetSecondLevelCache() {
        if (secondLevelCache == null) {
            secondLevelCache = LibFontBoot.getInstance().createDefaultCache();
        }
        return secondLevelCache;
    }

    @Override
    public void initialize() {
    }

    @Override
    public FontCache getSecondLevelCache() {
        return AWTFontRegistry.internalGetSecondLevelCache();
    }

    @Override
    public FontMetricsFactory createMetricsFactory() {
        return new AWTFontMetricsFactory();
    }

    @Override
    public FontFamily getFontFamily(String string) {
        AWTFontFamily aWTFontFamily = (AWTFontFamily)this.fontFamilyCache.get(string);
        if (aWTFontFamily != null) {
            return aWTFontFamily;
        }
        AWTFontFamily aWTFontFamily2 = new AWTFontFamily(string);
        this.fontFamilyCache.put(string, aWTFontFamily2);
        return aWTFontFamily2;
    }

    @Override
    public String[] getRegisteredFamilies() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.getAvailableFontFamilyNames();
    }

    @Override
    public String[] getAllRegisteredFamilies() {
        return this.getRegisteredFamilies();
    }
}

