/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.awt;

import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

public class AWTFontRecord
implements FontRecord,
FontIdentifier {
    private FontFamily fontFamily;
    private boolean bold;
    private boolean italics;

    public AWTFontRecord(FontFamily fontFamily, boolean bl, boolean bl2) {
        if (fontFamily == null) {
            throw new NullPointerException();
        }
        this.fontFamily = fontFamily;
        this.bold = bl;
        this.italics = bl2;
    }

    @Override
    public FontFamily getFamily() {
        return this.fontFamily;
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    @Override
    public boolean isItalic() {
        return this.italics;
    }

    @Override
    public boolean isOblique() {
        return this.italics;
    }

    @Override
    public FontIdentifier getIdentifier() {
        return this;
    }

    @Override
    public boolean isScalable() {
        return true;
    }

    @Override
    public FontType getFontType() {
        return FontType.AWT;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AWTFontRecord aWTFontRecord = (AWTFontRecord)object;
        if (this.bold != aWTFontRecord.bold) {
            return false;
        }
        if (this.italics != aWTFontRecord.italics) {
            return false;
        }
        return this.fontFamily.equals(aWTFontRecord.fontFamily);
    }

    @Override
    public int hashCode() {
        int n = this.fontFamily.hashCode();
        n = 29 * n + (this.bold ? 1 : 0);
        n = 29 * n + (this.italics ? 1 : 0);
        return n;
    }
}

