/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.afm;

import org.pentaho.reporting.libraries.fonts.afm.AfmFont;
import org.pentaho.reporting.libraries.fonts.afm.AfmHeader;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontSource;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

public class AfmFontRecord
implements FontSource,
FontIdentifier {
    private DefaultFontFamily fontFamily;
    private boolean bold;
    private boolean italic;
    private String fontFile;
    private boolean embeddable;

    public AfmFontRecord(AfmFont afmFont, DefaultFontFamily defaultFontFamily) {
        if (afmFont == null) {
            throw new NullPointerException();
        }
        if (defaultFontFamily == null) {
            throw new NullPointerException();
        }
        this.embeddable = afmFont.isEmbeddable();
        this.fontFile = afmFont.getFilename();
        this.fontFamily = defaultFontFamily;
        AfmHeader afmHeader = afmFont.getHeader();
        this.bold = afmHeader.getWeight() > 400;
        this.italic = afmFont.getDirectionSection(0).getItalicAngle() != 0.0;
    }

    @Override
    public FontFamily getFamily() {
        return this.fontFamily;
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    @Override
    public boolean isItalic() {
        return this.italic;
    }

    @Override
    public boolean isOblique() {
        return false;
    }

    @Override
    public FontIdentifier getIdentifier() {
        return this;
    }

    @Override
    public String getFontSource() {
        return this.fontFile;
    }

    @Override
    public boolean isEmbeddable() {
        return this.embeddable;
    }

    @Override
    public boolean isScalable() {
        return true;
    }

    @Override
    public FontType getFontType() {
        return FontType.AFM;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AfmFontRecord afmFontRecord = (AfmFontRecord)object;
        if (this.bold != afmFontRecord.bold) {
            return false;
        }
        if (this.embeddable != afmFontRecord.embeddable) {
            return false;
        }
        if (this.italic != afmFontRecord.italic) {
            return false;
        }
        if (!this.fontFamily.equals(afmFontRecord.fontFamily)) {
            return false;
        }
        return this.fontFile.equals(afmFontRecord.fontFile);
    }

    @Override
    public int hashCode() {
        int n = this.fontFamily.hashCode();
        n = 31 * n + (this.bold ? 1 : 0);
        n = 31 * n + (this.italic ? 1 : 0);
        n = 31 * n + this.fontFile.hashCode();
        n = 31 * n + (this.embeddable ? 1 : 0);
        return n;
    }
}

