/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class ParserEntityResolver
implements EntityResolver {
    private static final Log logger = LogFactory.getLog(ParserEntityResolver.class);
    private final HashMap deprecatedDTDs;
    private final HashMap dtds = new HashMap();
    private static ParserEntityResolver singleton;

    private ParserEntityResolver() {
        this.deprecatedDTDs = new HashMap();
    }

    public boolean setDTDLocation(String string, URL uRL) {
        if (this.isValid(uRL)) {
            this.dtds.put(string, uRL);
            return true;
        }
        logger.warn((Object)("Validate location failed for " + string + " location: " + uRL));
        return false;
    }

    public boolean setDTDLocation(String string, String string2, URL uRL) {
        if (this.isValid(uRL)) {
            this.dtds.put(string, uRL);
            this.dtds.put(string2, uRL);
            return true;
        }
        logger.warn((Object)("Validate location failed for " + string + " location: " + uRL));
        return false;
    }

    public URL getDTDLocation(String string) {
        return (URL)this.dtds.get(string);
    }

    private boolean isValid(URL uRL) {
        if (uRL == null) {
            return false;
        }
        try {
            InputStream inputStream = uRL.openStream();
            inputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        try {
            if (string == null) {
                URL uRL;
                if (string2 != null && (uRL = this.getDTDLocation(string2)) != null) {
                    InputSource inputSource = new InputSource(uRL.openStream());
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
                return null;
            }
            URL uRL = this.getDTDLocation(string);
            if (uRL != null) {
                InputSource inputSource = new InputSource(uRL.openStream());
                inputSource.setSystemId(string2);
                inputSource.setPublicId(string);
                return inputSource;
            }
            String string3 = this.getDeprecatedDTDMessage(string);
            if (string3 != null) {
                logger.info((Object)string3);
            } else {
                logger.info((Object)"A public ID was given for the document, but it was unknown or invalid.");
            }
            return null;
        }
        catch (IOException iOException) {
            logger.warn((Object)"Unable to open specified DTD", (Throwable)iOException);
            return null;
        }
    }

    public static synchronized ParserEntityResolver getDefaultResolver() {
        if (singleton == null) {
            singleton = new ParserEntityResolver();
        }
        return singleton;
    }

    public void setDeprecatedDTDMessage(String string, String string2) {
        this.deprecatedDTDs.put(string, string2);
    }

    public String getDeprecatedDTDMessage(String string) {
        return (String)this.deprecatedDTDs.get(string);
    }
}

