/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.io.IOException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.DefaultXmlDocumentInfo;
import org.pentaho.reporting.libraries.xmlns.parser.FixNamespaceUriAttributes;
import org.pentaho.reporting.libraries.xmlns.parser.NoRootHandlerException;
import org.pentaho.reporting.libraries.xmlns.parser.ParserEntityResolver;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlFactoryModule;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MultiplexRootElementHandler
extends RootXmlReadHandler {
    private XmlFactoryModule[] rootHandlers;
    private RootEntityResolver entityResolver = new RootEntityResolver();
    private boolean xmlnsUrisNotAvailable;
    private XmlFactoryModule selectedRootHandler;

    public MultiplexRootElementHandler(ResourceManager resourceManager, ResourceKey resourceKey, ResourceKey resourceKey2, long l, XmlFactoryModule[] xmlFactoryModuleArray) {
        super(resourceManager, resourceKey, resourceKey2, l);
        this.rootHandlers = (XmlFactoryModule[])xmlFactoryModuleArray.clone();
    }

    public boolean isXmlnsUrisNotAvailable() {
        return this.xmlnsUrisNotAvailable;
    }

    public void setXmlnsUrisNotAvailable(boolean bl) {
        this.xmlnsUrisNotAvailable = bl;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public ParserEntityResolver getParserEntityResolver() {
        return this.entityResolver.getEntityResolver();
    }

    protected XmlFactoryModule[] getRootHandlers() {
        return (XmlFactoryModule[])this.rootHandlers.clone();
    }

    @Override
    protected void interceptFirstStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        DefaultXmlDocumentInfo defaultXmlDocumentInfo = new DefaultXmlDocumentInfo();
        defaultXmlDocumentInfo.setPublicDTDId(this.entityResolver.getPublicId());
        defaultXmlDocumentInfo.setSystemDTDId(this.entityResolver.getSystemId());
        defaultXmlDocumentInfo.setRootElement(string2);
        defaultXmlDocumentInfo.setRootElementNameSpace(string);
        defaultXmlDocumentInfo.setRootElementAttributes(attributes);
        String string4 = attributes.getValue("xmlns");
        if (string4 != null) {
            defaultXmlDocumentInfo.setDefaultNameSpace(string4);
        } else {
            defaultXmlDocumentInfo.setDefaultNameSpace("");
        }
        XmlFactoryModule xmlFactoryModule = null;
        int n = -1;
        for (int i = 0; i < this.rootHandlers.length; ++i) {
            object = this.rootHandlers[i];
            int n2 = object.getDocumentSupport(defaultXmlDocumentInfo);
            if (n2 <= n) continue;
            xmlFactoryModule = object;
            n = n2;
        }
        if (n < 0 || xmlFactoryModule == null) {
            throw new NoRootHandlerException("No suitable root handler known for this document: " + defaultXmlDocumentInfo);
        }
        XmlReadHandler xmlReadHandler = xmlFactoryModule.createReadHandler(defaultXmlDocumentInfo);
        if (xmlReadHandler == null) {
            throw new NoRootHandlerException("Unable to create the root handler. " + xmlFactoryModule);
        }
        this.selectedRootHandler = xmlFactoryModule;
        object = defaultXmlDocumentInfo.getDefaultNameSpace();
        if ((object == null || "".equals(object)) && (object = xmlFactoryModule.getDefaultNamespace(defaultXmlDocumentInfo)) != null && !"".equals(object)) {
            defaultXmlDocumentInfo.setRootElementNameSpace((String)object);
        }
        this.pushDefaultNamespace((String)object);
        Object object2 = (string == null || "".equals(string)) && object != null ? object : string;
        attributes = new FixNamespaceUriAttributes((String)object2, attributes);
        this.installRootHandler(xmlReadHandler, (String)object2, string2, this.wrapAttributes(attributes));
    }

    public XmlFactoryModule getSelectedRootHandler() {
        return this.selectedRootHandler;
    }

    private static class RootEntityResolver
    implements EntityResolver {
        private ParserEntityResolver entityResolver = ParserEntityResolver.getDefaultResolver();
        private String publicId;
        private String systemId;

        private RootEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            this.publicId = string;
            this.systemId = string2;
            return this.entityResolver.resolveEntity(string, string2);
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public ParserEntityResolver getEntityResolver() {
            return this.entityResolver;
        }
    }
}

