/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.base.util.Empty;

public class AttributeMap
implements Serializable,
Cloneable {
    private static final String[] EMPTY_NAMESPACES = new String[0];
    private static final long serialVersionUID = -7442871030874215436L;
    private HashMap namespaces;

    public AttributeMap() {
    }

    public AttributeMap(AttributeMap attributeMap) {
        if (attributeMap == null) {
            return;
        }
        if (attributeMap.namespaces == null) {
            return;
        }
        this.namespaces = (HashMap)attributeMap.namespaces.clone();
        for (Map.Entry entry : this.namespaces.entrySet()) {
            HashMap hashMap = (HashMap)entry.getValue();
            entry.setValue(hashMap.clone());
        }
    }

    public Object clone() {
        try {
            AttributeMap attributeMap = (AttributeMap)super.clone();
            if (this.namespaces != null) {
                attributeMap.namespaces = (HashMap)this.namespaces.clone();
                for (Map.Entry entry : attributeMap.namespaces.entrySet()) {
                    HashMap hashMap = (HashMap)entry.getValue();
                    entry.setValue(hashMap.clone());
                }
            }
            return attributeMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Cannot happen: Clone not supported exception");
        }
    }

    public Object setAttribute(String string, String string2, Object object) {
        HashMap hashMap;
        if (string == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (string2 == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if ((hashMap = (HashMap)this.namespaces.get(string)) == null) {
            if (object == null) {
                return null;
            }
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put(string2, object);
            this.namespaces.put(string, hashMap2);
            return null;
        }
        if (object == null) {
            Object v = hashMap.remove(string2);
            if (hashMap.isEmpty()) {
                this.namespaces.remove(string);
            }
            return v;
        }
        return hashMap.put(string2, object);
    }

    public Object getAttribute(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (string2 == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.namespaces == null) {
            return null;
        }
        HashMap hashMap = (HashMap)this.namespaces.get(string);
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(string2);
    }

    public Object getFirstAttribute(String string) {
        if (string == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.namespaces == null) {
            return null;
        }
        for (Map.Entry entry : this.namespaces.entrySet()) {
            HashMap hashMap = (HashMap)entry.getValue();
            Object v = hashMap.get(string);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public Map getAttributes(String string) {
        if (string == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (this.namespaces == null) {
            return Empty.MAP;
        }
        HashMap hashMap = (HashMap)this.namespaces.get(string);
        if (hashMap == null) {
            return Empty.MAP;
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public String[] getNames(String string) {
        if (string == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (this.namespaces == null) {
            return EMPTY_NAMESPACES;
        }
        HashMap hashMap = (HashMap)this.namespaces.get(string);
        if (hashMap == null) {
            return EMPTY_NAMESPACES;
        }
        return hashMap.keySet().toArray(new String[hashMap.size()]);
    }

    public String[] getNameSpaces() {
        if (this.namespaces == null) {
            return EMPTY_NAMESPACES;
        }
        return this.namespaces.keySet().toArray(new String[this.namespaces.size()]);
    }
}

