/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.common;

import java.util.Arrays;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.util.LinkedMap;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class AttributeList {
    public static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private LinkedMap entryList = new LinkedMap();
    private AttributeEntry lookupKey = new AttributeEntry(null, "lookup", "value");
    private transient AttributeEntry[] arrayCache;

    public Iterator iterator() {
        return Arrays.asList(this.entryList.values()).iterator();
    }

    public AttributeEntry[] toArray() {
        if (this.arrayCache == null) {
            this.arrayCache = (AttributeEntry[])this.entryList.values((Object[])new AttributeEntry[this.entryList.size()]);
        }
        return (AttributeEntry[])this.arrayCache.clone();
    }

    public void setAttribute(String string, String string2, String string3) {
        if (string3 == null) {
            this.removeAttribute(string, string2);
            return;
        }
        AttributeEntry attributeEntry = new AttributeEntry(string, string2, string3);
        this.arrayCache = null;
        this.entryList.put((Object)attributeEntry, (Object)attributeEntry);
    }

    public String getAttribute(String string, String string2) {
        return this.getAttribute(string, string2, null);
    }

    public String getAttribute(String string, String string2, String string3) {
        this.lookupKey.update(string, string2, "");
        AttributeEntry attributeEntry = (AttributeEntry)this.entryList.get((Object)this.lookupKey);
        if (attributeEntry != null) {
            return attributeEntry.getValue();
        }
        return string3;
    }

    public void removeAttribute(String string, String string2) {
        this.lookupKey.update(string, string2, "");
        this.entryList.remove((Object)this.lookupKey);
        this.arrayCache = null;
    }

    public boolean isEmpty() {
        return this.entryList.isEmpty();
    }

    public void addNamespaceDeclaration(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (string == null || "".equals(string)) {
            this.setAttribute(XMLNS_NAMESPACE, "", string2);
        } else {
            this.setAttribute(XMLNS_NAMESPACE, string, string2);
        }
    }

    public void removeNamespaceDeclaration(String string) {
        if (string == null || "".equals(string)) {
            this.removeAttribute(XMLNS_NAMESPACE, "");
        } else {
            this.removeAttribute(XMLNS_NAMESPACE, string);
        }
    }

    public boolean isNamespacePrefixDefined(String string) {
        return this.getAttribute(XMLNS_NAMESPACE, string) != null;
    }

    public boolean isNamespaceUriDefined(String string) {
        if (this.entryList.isEmpty()) {
            return false;
        }
        AttributeEntry[] attributeEntryArray = this.toArray();
        for (int i = 0; i < attributeEntryArray.length; ++i) {
            AttributeEntry attributeEntry = attributeEntryArray[i];
            if (!ObjectUtilities.equal((Object)attributeEntry.getValue(), (Object)string) || !XMLNS_NAMESPACE.equals(attributeEntry.getNamespace())) continue;
            return true;
        }
        return false;
    }

    public static class AttributeEntry {
        private String namespace;
        private String name;
        private String value;

        public AttributeEntry(String string, String string2, String string3) {
            if (string2 == null) {
                throw new NullPointerException("Name must not be null. [" + string2 + ", " + string3 + ']');
            }
            if (string3 == null) {
                throw new NullPointerException("Value must not be null. [" + string2 + ", " + string3 + ']');
            }
            this.namespace = string;
            this.name = string2;
            this.value = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AttributeEntry attributeEntry = (AttributeEntry)object;
            if (!this.name.equals(attributeEntry.name)) {
                return false;
            }
            return !(this.namespace != null ? !this.namespace.equals(attributeEntry.namespace) : attributeEntry.namespace != null);
        }

        public int hashCode() {
            int n = this.namespace != null ? this.namespace.hashCode() : 0;
            n = 29 * n + this.name.hashCode();
            return n;
        }

        protected void update(String string, String string2, String string3) {
            if (string2 == null) {
                throw new NullPointerException("Name must not be null. [" + string2 + ", " + string3 + ']');
            }
            if (string3 == null) {
                throw new NullPointerException("Value must not be null. [" + string2 + ", " + string3 + ']');
            }
            this.namespace = string;
            this.name = string2;
            this.value = string3;
        }
    }
}

