/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.agenda;

import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XStorable;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.wizards.agenda.AgendaTemplate;
import com.sun.star.wizards.agenda.AgendaWizardDialog;
import com.sun.star.wizards.agenda.CGAgenda;
import com.sun.star.wizards.agenda.TopicsControl;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.text.ViewHandler;
import com.sun.star.wizards.ui.PathSelection;
import com.sun.star.wizards.ui.XPathSelectionListener;
import com.sun.star.wizards.ui.event.DataAware;
import com.sun.star.wizards.ui.event.RadioDataAware;
import com.sun.star.wizards.ui.event.UnoDataAware;
import java.util.Vector;

public class AgendaWizardDialogImpl
extends AgendaWizardDialog {
    static boolean running;
    AgendaTemplate agendaTemplate;
    private CGAgenda agenda;
    private TopicsControl topicsControl;
    private String[][] agendaTemplates;
    PathSelection myPathSelection;
    String sTemplatePath;
    String sUserTemplatePath;
    String sBitmapPath;
    String sPath;
    private FileAccess fileAccess1;
    private boolean filenameChanged = false;

    public AgendaWizardDialogImpl(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
    }

    @Override
    protected void enterStep(int n, int n2) {
    }

    @Override
    protected void leaveStep(int n, int n2) {
    }

    public void startWizard() {
        running = true;
        try {
            this.agenda = new CGAgenda();
            Object object = Configuration.getConfigurationRoot(this.xMSF, "/org.openoffice.Office.Writer/Wizards/Agenda", false);
            this.agenda.readConfiguration(object, "cp_");
            this.agendaTemplate = new AgendaTemplate(this.xMSF, this.agenda, this.resources, (XTerminateListener)this);
            this.initializeTemplates();
            this.agendaTemplate.load(this.agendaTemplates[1][this.agenda.cp_AgendaType], new Vector());
            this.buildStep1();
            this.buildStep2();
            this.buildStep3();
            this.buildStep4();
            this.buildStep5();
            this.topicsControl = new TopicsControl(this, this.xMSF, this.agenda);
            this.buildStep6();
            this.drawNaviBar();
            this.initializePaths();
            this.insertPathSelectionControl();
            XWindow xWindow = this.agendaTemplate.xFrame.getContainerWindow();
            XWindowPeer xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)xWindow);
            this.createWindowPeer(xWindowPeer);
            this.addRoadmap();
            this.insertRoadMapItems(new String[]{this.resources.resStep1, this.resources.resStep2, this.resources.resStep3, this.resources.resStep4, this.resources.resStep5, this.resources.resStep6}, new int[]{1, 2, 3, 4, 5, 6}, new boolean[]{true, true, true, true, true, true});
            this.setMaxStep(6);
            this.makeDA();
            if (this.myPathSelection.xSaveTextBox.getText().equalsIgnoreCase("")) {
                this.myPathSelection.initializePath();
            }
            this.executeDialog((XInterface)this.agendaTemplate.xFrame);
            this.removeTerminateListener();
            this.closeDocument();
            running = false;
        }
        catch (Exception exception) {
            this.removeTerminateListener();
            exception.printStackTrace();
            running = false;
            return;
        }
    }

    public void insertPathSelectionControl() {
        this.myPathSelection = new PathSelection(this.xMSF, this, 0, 1);
        this.myPathSelection.insert(6, 97, 70, 205, (short)45, this.resources.reslblTemplatePath_value, true, "HID:41075", "HID:41076");
        this.myPathSelection.sDefaultDirectory = this.sUserTemplatePath;
        this.myPathSelection.sDefaultName = "myAgendaTemplate.ott";
        this.myPathSelection.sDefaultFilter = "writer8_template";
        this.myPathSelection.addSelectionListener(new myPathSelectionListener());
    }

    private void initializePaths() {
        try {
            this.sTemplatePath = FileAccess.getOfficePath(this.xMSF, "Template", "share", "/wizard");
            this.sUserTemplatePath = FileAccess.getOfficePath(this.xMSF, "Template", "user", "");
            this.sBitmapPath = FileAccess.combinePaths(this.xMSF, this.sTemplatePath, "/wizard/bitmap");
        }
        catch (NoValidPathException noValidPathException) {
            noValidPathException.printStackTrace();
        }
    }

    private void checkSavePath() {
        if (this.agenda.cp_TemplatePath == null || this.agenda.cp_TemplatePath.equals("") || !this.getFileAccess().exists(FileAccess.getParentDir(this.agenda.cp_TemplatePath), false) || !this.getFileAccess().isDirectory(FileAccess.getParentDir(this.agenda.cp_TemplatePath))) {
            try {
                this.agenda.cp_TemplatePath = FileAccess.connectURLs(FileAccess.getOfficePath(this.xMSF, "Work", "", ""), this.resources.resDefaultFilename);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void makeDA() {
        this.setControlProperty("listPageDesign", "StringItemList", this.agendaTemplates[0]);
        this.checkSavePath();
        UnoDataAware.attachListBox(this.agenda, "cp_AgendaType", this.listPageDesign, null, true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_IncludeMinutes", this.chkMinutes, null, true).updateUI();
        UnoDataAware.attachEditControl(this.agenda, "cp_Title", this.txtTitle, this.agendaTemplate, true).updateUI();
        UnoDataAware.attachDateControl(this.agenda, "cp_Date", this.txtDate, this.agendaTemplate, true).updateUI();
        UnoDataAware.attachTimeControl(this.agenda, "cp_Time", this.txtTime, this.agendaTemplate, true).updateUI();
        UnoDataAware.attachEditControl(this.agenda, "cp_Location", this.cbLocation, this.agendaTemplate, true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowMeetingType", this.chkMeetingTitle, new RedrawListener("<meeting-type>"), true);
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowRead", this.chkRead, new RedrawListener("<read>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowBring", this.chkBring, new RedrawListener("<bring>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowNotes", this.chkNotes, new RedrawListener("<notes>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowCalledBy", this.chkConvenedBy, new RedrawListener("<called-by>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowFacilitator", this.chkPresiding, new RedrawListener("<facilitator>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowNotetaker", this.chkNoteTaker, new RedrawListener("<notetaker>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowTimekeeper", this.chkTimekeeper, new RedrawListener("<timekeeper>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowAttendees", this.chkAttendees, new RedrawListener("<attendees>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowObservers", this.chkObservers, new RedrawListener("<observers>"), true).updateUI();
        UnoDataAware.attachCheckBox(this.agenda, "cp_ShowResourcePersons", this.chkResourcePersons, new RedrawListener("<resource-persons>"), true).updateUI();
        UnoDataAware.attachEditControl(this.agenda, "cp_TemplateName", this.txtTemplateName, null, true).updateUI();
        RadioDataAware.attachRadioButtons(this.agenda, "cp_ProceedMethod", new Object[]{this.optCreateAgenda, this.optMakeChanges}, null, true).updateUI();
        this.listPageDesign.addItemListener(new XItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AgendaWizardDialogImpl.this.pageDesignChanged(itemEvent);
            }

            public void disposing(EventObject eventObject) {
            }
        });
    }

    public static void main(String[] stringArray) {
        String string = "uno:socket,host=127.0.0.1,port=8100;urp,negotiate=0,forcesynchronous=1;StarOffice.NamingService";
        try {
            XMultiServiceFactory xMultiServiceFactory = Desktop.connect(string);
            AgendaWizardDialogImpl agendaWizardDialogImpl = new AgendaWizardDialogImpl(xMultiServiceFactory);
            agendaWizardDialogImpl.startWizard();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean initializeTemplates() {
        try {
            String string = FileAccess.getOfficePath(this.xMSF, "Template", "share", "/wizard");
            String string2 = FileAccess.combinePaths(this.xMSF, string, "/wizard/agenda");
            this.agendaTemplates = FileAccess.getFolderTitles(this.xMSF, "aw", string2);
            return true;
        }
        catch (NoValidPathException noValidPathException) {
            noValidPathException.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void pageDesignChanged(ItemEvent itemEvent) {
        int n = itemEvent.Selected;
        try {
            this.agendaTemplate.load(this.agendaTemplates[1][n], this.topicsControl.getTopicsData());
        }
        catch (Exception exception) {
            SystemDialog.showMessageBox(this.xMSF, "ErrBox", 0x400000, this.resources.resErrOpenTemplate);
            exception.printStackTrace();
        }
    }

    public void templateTitleChanged() {
        String string = (String)Helper.getUnoPropertyValue(AgendaWizardDialogImpl.getModel(this.txtTemplateName), "Text");
        this.agendaTemplate.setTemplateTitle(string);
    }

    private FileAccess getFileAccess() {
        if (this.fileAccess1 == null) {
            try {
                this.fileAccess1 = new FileAccess(this.xMSF);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.fileAccess1;
    }

    public void saveAs() {
        try {
            this.checkSavePath();
            SystemDialog systemDialog = SystemDialog.createStoreDialog(this.xMSF);
            systemDialog.addFilterToDialog("ott", "writer8_template", true);
            String string = systemDialog.callStoreDialog(FileAccess.getParentDir(this.agenda.cp_TemplatePath), FileAccess.getFilename(this.agenda.cp_TemplatePath));
            if (string != null) {
                this.agenda.cp_TemplatePath = string;
                this.setFilename(string);
                this.filenameChanged = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setFilename(String string) {
        try {
            String string2 = this.getFileAccess().getPath(string, "");
            Helper.setUnoPropertyValue(AgendaWizardDialogImpl.getModel(this.myPathSelection.xSaveTextBox), "Text", string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void insertRow() {
        this.topicsControl.insertRow();
    }

    public void removeRow() {
        this.topicsControl.removeRow();
    }

    public void rowUp() {
        this.topicsControl.rowUp();
    }

    public void rowDown() {
        this.topicsControl.rowDown();
    }

    @Override
    public void cancelWizard() {
        this.xDialog.endExecute();
        running = false;
    }

    @Override
    public void finishWizard() {
        XTextDocument xTextDocument;
        PropertyValue[] propertyValueArray;
        boolean bl = false;
        try {
            int n;
            propertyValueArray = new FileAccess(this.xMSF);
            this.sPath = this.myPathSelection.getSelectedPath();
            if (this.sPath.equals("")) {
                this.myPathSelection.triggerPathPicker();
                this.sPath = this.myPathSelection.getSelectedPath();
            }
            this.sPath = propertyValueArray.getURL(this.sPath);
            if (!this.filenameChanged && propertyValueArray.exists(this.sPath, true) && (n = SystemDialog.showMessageBox(this.xMSF, this.xControl.getPeer(), "MessBox", -2130706432, this.resources.resFileExists)) == 3) {
                return;
            }
            this.agendaTemplate.xTextDocument.lockControllers();
            xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this.agendaTemplate.document);
            bl = OfficeDocument.store(this.xMSF, (XComponent)xTextDocument, this.sPath, "writer8_template", false, this.resources.resErrSaveTemplate);
        }
        catch (Exception exception) {
            SystemDialog.showMessageBox(this.xMSF, this.xControl.getPeer(), "ErrBox", 0x400000, this.resources.resErrSaveTemplate);
        }
        if (bl) {
            Object object;
            try {
                this.topicsControl.saveTopics(this.agenda);
                propertyValueArray = Configuration.getConfigurationRoot(this.xMSF, "/org.openoffice.Office.Writer/Wizards/Agenda", true);
                this.agenda.writeConfiguration(propertyValueArray, "cp_");
                Configuration.commit(propertyValueArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.agendaTemplate.finish(this.topicsControl.getTopicsData());
            try {
                propertyValueArray = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.agendaTemplate.document);
                propertyValueArray.store();
            }
            catch (Exception exception) {
                SystemDialog.showMessageBox(this.xMSF, "ErrBox", 0x400000, this.resources.resErrSaveTemplate);
                exception.printStackTrace();
            }
            this.agendaTemplate.xTextDocument.unlockControllers();
            propertyValueArray = new PropertyValue[2];
            propertyValueArray[0] = new PropertyValue();
            propertyValueArray[0].Name = "AsTemplate";
            propertyValueArray[0].Value = this.agenda.cp_ProceedMethod == 1 ? Boolean.TRUE : Boolean.FALSE;
            propertyValueArray[1] = new PropertyValue();
            propertyValueArray[1].Name = "InteractionHandler";
            try {
                object = (XInteractionHandler)UnoRuntime.queryInterface(XInteractionHandler.class, (Object)this.xMSF.createInstance("com.sun.star.comp.uui.UUIInteractionHandler"));
                propertyValueArray[1].Value = object;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = OfficeDocument.load((XInterface)Desktop.getDesktop(this.xMSF), this.sPath, "_default", new PropertyValue[0]);
            xTextDocument = (XTextDocument)object;
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xTextDocument);
            ViewHandler viewHandler = new ViewHandler(xMultiServiceFactory, xTextDocument);
            try {
                viewHandler.setViewSetting("ZoomType", new Short(0));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.agendaTemplate.xTextDocument.unlockControllers();
            return;
        }
        this.xDialog.endExecute();
        running = false;
    }

    private void closeDocument() {
        try {
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)this.agendaTemplate.xFrame);
            xCloseable.close(false);
        }
        catch (CloseVetoException closeVetoException) {
            closeVetoException.printStackTrace();
        }
    }

    private class RedrawListener
    implements DataAware.Listener {
        private String itemName;

        public RedrawListener(String string) {
            this.itemName = string;
        }

        @Override
        public void eventPerformed(Object object) {
            AgendaWizardDialogImpl.this.agendaTemplate.xTextDocument.lockControllers();
            AgendaWizardDialogImpl.this.agendaTemplate.redraw(this.itemName);
            AgendaWizardDialogImpl.this.agendaTemplate.xTextDocument.unlockControllers();
        }
    }

    private class myPathSelectionListener
    implements XPathSelectionListener {
        private myPathSelectionListener() {
        }

        @Override
        public void validatePath() {
            if (AgendaWizardDialogImpl.this.myPathSelection.usedPathPicker) {
                AgendaWizardDialogImpl.this.filenameChanged = true;
            }
            AgendaWizardDialogImpl.this.myPathSelection.usedPathPicker = false;
        }
    }
}

