/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.UIManager;
import org.openoffice.java.accessibility.Container;
import org.openoffice.java.accessibility.List;

public class ComboBox
extends Container {
    private XAccessibleAction unoAccessibleAction = null;

    public ComboBox(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(AccessibleRole.COMBO_BOX, xAccessible, xAccessibleContext);
    }

    @Override
    public Component add(Component component) {
        if (component instanceof List) {
            return super.add(component, 0);
        }
        return super.add(component);
    }

    @Override
    public AccessibleContext createAccessibleContext() {
        return new AccessibleComboBox();
    }

    protected class AccessibleComboBox
    extends Container.AccessibleContainer
    implements AccessibleAction {
        protected AccessibleComboBox() {
            super(ComboBox.this);
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            if (ComboBox.this.unoAccessibleAction == null) {
                ComboBox.this.unoAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)ComboBox.this.unoAccessibleContext);
                if (ComboBox.this.unoAccessibleAction == null) {
                    return null;
                }
            }
            return this;
        }

        @Override
        public boolean doAccessibleAction(int n) {
            if (n == 0) {
                try {
                    return ComboBox.this.unoAccessibleAction.doAccessibleAction(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public String getAccessibleActionDescription(int n) {
            return UIManager.getString("ComboBox.togglePopupText");
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }
    }
}

