/*
 * Decompiled with CFR 0.152.
 */
import com.sun.star.geometry.AffineMatrix2D;
import com.sun.star.geometry.RealBezierSegment2D;
import com.sun.star.geometry.RealPoint2D;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.rendering.AnimationAttributes;
import com.sun.star.rendering.RenderState;
import com.sun.star.rendering.StrokeAttributes;
import com.sun.star.rendering.ViewState;
import com.sun.star.rendering.XBezierPolyPolygon2D;
import com.sun.star.rendering.XBitmap;
import com.sun.star.rendering.XCanvasFont;
import com.sun.star.rendering.XIntegerBitmap;
import com.sun.star.rendering.XLinePolyPolygon2D;
import com.sun.star.rendering.XPolyPolygon2D;
import com.sun.star.uno.UnoRuntime;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class CanvasUtils {
    public static final byte alsoSetupPaint = 0;
    public static final byte dontSetupPaint = 1;

    public static AffineTransform makeTransform(AffineMatrix2D affineMatrix2D) {
        return new AffineTransform(affineMatrix2D.m00, affineMatrix2D.m10, affineMatrix2D.m01, affineMatrix2D.m11, affineMatrix2D.m02, affineMatrix2D.m12);
    }

    public static AffineMatrix2D makeAffineMatrix2D(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        return new AffineMatrix2D(dArray[0], dArray[2], dArray[4], dArray[1], dArray[3], dArray[5]);
    }

    public static void initGraphics(Graphics2D graphics2D) {
        if (graphics2D != null) {
            RenderingHints renderingHints = new RenderingHints(null);
            boolean bl = true;
            if (bl) {
                renderingHints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
                renderingHints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED));
                renderingHints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR));
                renderingHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED));
                renderingHints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT));
                renderingHints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            } else {
                renderingHints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED));
                renderingHints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR));
                renderingHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED));
                renderingHints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT));
                renderingHints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF));
            }
            renderingHints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
            renderingHints.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    public static GeneralPath makeGenPathFromBezierPoints(RealBezierSegment2D[][] realBezierSegment2DArray) {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < realBezierSegment2DArray.length; ++i) {
            if (realBezierSegment2DArray[i].length > 0) {
                generalPath.moveTo((float)realBezierSegment2DArray[i][0].Px, (float)realBezierSegment2DArray[i][0].Py);
            }
            for (int j = 1; j < realBezierSegment2DArray[i].length; ++j) {
                CanvasUtils.printLog("makeGenPathFromBezierPoints: point added.");
                generalPath.curveTo((float)realBezierSegment2DArray[i][j - 1].C1x, (float)realBezierSegment2DArray[i][j - 1].C1y, (float)realBezierSegment2DArray[i][j - 1].C2x, (float)realBezierSegment2DArray[i][j - 1].C2y, (float)realBezierSegment2DArray[i][j].Px, (float)realBezierSegment2DArray[i][j].Py);
            }
        }
        return generalPath;
    }

    public static GeneralPath makeGenPathFromBezierPoly(XBezierPolyPolygon2D xBezierPolyPolygon2D) {
        try {
            RealBezierSegment2D[][] realBezierSegment2DArray = xBezierPolyPolygon2D.getBezierSegments(0, -1, 0, -1);
            return CanvasUtils.makeGenPathFromBezierPoints(realBezierSegment2DArray);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return new GeneralPath();
        }
    }

    public static GeneralPath makeGenPathFromLinePoints(RealPoint2D[][] realPoint2DArray) {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < realPoint2DArray.length; ++i) {
            if (realPoint2DArray[i].length > 0) {
                generalPath.moveTo((float)realPoint2DArray[i][0].X, (float)realPoint2DArray[i][0].Y);
            }
            for (int j = 1; j < realPoint2DArray[i].length; ++j) {
                CanvasUtils.printLog("makeGenPathFromLinePoints: point (" + realPoint2DArray[i][j].X + "," + realPoint2DArray[i][j].Y + ") added.");
                generalPath.lineTo((float)realPoint2DArray[i][j].X, (float)realPoint2DArray[i][j].Y);
            }
        }
        return generalPath;
    }

    public static GeneralPath makeGenPathFromLinePoly(XLinePolyPolygon2D xLinePolyPolygon2D) {
        try {
            RealPoint2D[][] realPoint2DArray = xLinePolyPolygon2D.getPoints(0, -1, 0, -1);
            return CanvasUtils.makeGenPathFromLinePoints(realPoint2DArray);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return new GeneralPath();
        }
    }

    public static GeneralPath makeGeneralPath(XPolyPolygon2D xPolyPolygon2D) {
        if (xPolyPolygon2D instanceof BezierPolyPolygon) {
            CanvasUtils.printLog("makeGeneralPath: bezier impl used.");
            return ((BezierPolyPolygon)xPolyPolygon2D).getJavaPath();
        }
        if (xPolyPolygon2D instanceof LinePolyPolygon) {
            CanvasUtils.printLog("makeGeneralPath: line impl used.");
            return ((LinePolyPolygon)xPolyPolygon2D).getJavaPath();
        }
        XBezierPolyPolygon2D xBezierPolyPolygon2D = (XBezierPolyPolygon2D)UnoRuntime.queryInterface(XBezierPolyPolygon2D.class, (Object)xPolyPolygon2D);
        if (xBezierPolyPolygon2D != null) {
            return CanvasUtils.makeGenPathFromBezierPoly(xBezierPolyPolygon2D);
        }
        XLinePolyPolygon2D xLinePolyPolygon2D = (XLinePolyPolygon2D)UnoRuntime.queryInterface(XLinePolyPolygon2D.class, (Object)xPolyPolygon2D);
        if (xLinePolyPolygon2D != null) {
            return CanvasUtils.makeGenPathFromLinePoly(xLinePolyPolygon2D);
        }
        CanvasUtils.printLog("makeGeneralPath: Cannot access polygon data, given interface has class" + xPolyPolygon2D.getClass().getName());
        return new GeneralPath();
    }

    public static BufferedImage getBufferedImage(XBitmap xBitmap) {
        if (xBitmap instanceof CanvasBitmap) {
            CanvasUtils.printLog("getBufferedImage: CanvasBitmap impl used.");
            return ((CanvasBitmap)xBitmap).getBufferedImage();
        }
        XIntegerBitmap xIntegerBitmap = (XIntegerBitmap)UnoRuntime.queryInterface(XIntegerBitmap.class, (Object)xBitmap);
        if (xIntegerBitmap != null) {
            return null;
        }
        return null;
    }

    public static byte[] int2byte(int[] nArray) {
        byte[] byArray = new byte[4 * nArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            byArray[n] = (byte)(nArray[i] & 0xFF);
            byArray[n + 1] = (byte)(nArray[i] / 256 & 0xFF);
            byArray[n + 2] = (byte)(nArray[i] / 256 / 256 & 0xFF);
            byArray[n + 3] = (byte)(nArray[i] / 256 / 256 / 256 & 0xFF);
            n += 4;
        }
        return byArray;
    }

    public static int[] byte2int(byte[] byArray) {
        int[] nArray = new int[(byArray.length + 3) / 4];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = byArray[n] + (byArray[n + 1] + (byArray[n + 2] + byArray[n + 3] * 256) * 256) * 256;
            n += 4;
        }
        return nArray;
    }

    public static int javaRuleFromCompositeOp(byte by) {
        int n = 3;
        switch (by) {
            case 0: {
                CanvasUtils.printLog("javaRuleFromCompositeOp: clear selected");
                n = 1;
                break;
            }
            case 1: {
                CanvasUtils.printLog("javaRuleFromCompositeOp: src selected");
                n = 2;
                break;
            }
            case 2: {
                CanvasUtils.printLog("javaRuleFromCompositeOp: dst selected");
                n = 9;
                break;
            }
            case 3: {
                CanvasUtils.printLog("javaRuleFromCompositeOp: over selected");
                n = 3;
                break;
            }
            case 4: {
                CanvasUtils.printLog("javaRuleFromCompositeOp: under selected");
                n = 4;
                break;
            }
            case 5: {
                CanvasUtils.printLog("javaRuleFromCompositeOp: inside selected");
                n = 1;
                break;
            }
            case 6: {
                CanvasUtils.printLog("javaRuleFromCompositeOp: inReverse selected");
                n = 1;
                break;
            }
            case 7: {
                CanvasUtils.printLog("javaRuleFromCompositeOp: outside selected");
                n = 1;
                break;
            }
            case 8: {
                CanvasUtils.printLog("javaRuleFromCompositeOp: outReverse selected");
                n = 1;
                break;
            }
            case 11: {
                CanvasUtils.printLog("javaRuleFromCompositeOp: xor selected");
                n = 1;
                break;
            }
            case 12: {
                CanvasUtils.printLog("javaRuleFromCompositeOp: add selected");
                n = 1;
                break;
            }
            case 13: {
                CanvasUtils.printLog("javaRuleFromCompositeOp: saturate selected");
                n = 1;
                break;
            }
            default: {
                CanvasUtils.printLog("javaRuleFromCompositeOp: Unexpected compositing rule");
            }
        }
        return n;
    }

    public static AlphaComposite makeAlphaComposite(byte by) {
        return AlphaComposite.getInstance(CanvasUtils.javaRuleFromCompositeOp(by));
    }

    public static AlphaComposite makeAlphaCompositeAlpha(byte by, double d) {
        return AlphaComposite.getInstance(CanvasUtils.javaRuleFromCompositeOp(by), (float)d);
    }

    public static AffineTransform ViewConcatRenderTransform(ViewState viewState, RenderState renderState) {
        AffineTransform affineTransform = CanvasUtils.makeTransform(viewState.AffineTransform);
        affineTransform.concatenate(CanvasUtils.makeTransform(renderState.AffineTransform));
        CanvasUtils.printTransform(affineTransform, "ViewConcatRenderTransform");
        return affineTransform;
    }

    public static void setupGraphicsState(Graphics2D graphics2D, ViewState viewState, RenderState renderState, byte by) {
        graphics2D.setTransform(CanvasUtils.ViewConcatRenderTransform(viewState, renderState));
        if (viewState.Clip != null) {
            Area area = new Area(CanvasUtils.makeGeneralPath(viewState.Clip));
            if (renderState.Clip != null) {
                area.intersect(new Area(CanvasUtils.makeGeneralPath(renderState.Clip)));
            }
            graphics2D.setClip(area);
        } else if (renderState.Clip != null) {
            Area area = new Area(CanvasUtils.makeGeneralPath(renderState.Clip));
            graphics2D.setClip(area);
        } else {
            graphics2D.setClip(new Rectangle(-1000000, -1000000, 2000000, 2000000));
        }
        if (by == 0) {
            switch (renderState.DeviceColor.length) {
                case 3: {
                    CanvasUtils.printLog("setupGraphicsState: Color(" + renderState.DeviceColor[0] + "," + renderState.DeviceColor[1] + "," + renderState.DeviceColor[2] + ") set.");
                    graphics2D.setColor(new Color((float)renderState.DeviceColor[0], (float)renderState.DeviceColor[1], (float)renderState.DeviceColor[2]));
                    break;
                }
                case 4: {
                    CanvasUtils.printLog("setupGraphicsState: Color(" + renderState.DeviceColor[0] + "," + renderState.DeviceColor[1] + "," + renderState.DeviceColor[2] + "," + renderState.DeviceColor[3] + ") set.");
                    graphics2D.setColor(new Color((float)renderState.DeviceColor[0], (float)renderState.DeviceColor[1], (float)renderState.DeviceColor[2], (float)renderState.DeviceColor[3]));
                    break;
                }
                default: {
                    CanvasUtils.printLog("setupGraphicsState: unexpected number of " + renderState.DeviceColor.length + " color components!");
                }
            }
        }
        graphics2D.setComposite(CanvasUtils.makeAlphaComposite(renderState.CompositeOperation));
    }

    public static void applyStrokeAttributes(Graphics2D graphics2D, StrokeAttributes strokeAttributes) {
        int n = 0;
        if (strokeAttributes.StartCapType != strokeAttributes.EndCapType) {
            CanvasUtils.printLog("applyStrokeAttributes: different start and end caps are not yet supported!");
        }
        if (strokeAttributes.LineArray.length != 0) {
            CanvasUtils.printLog("applyStrokeAttributes: multi-strokes are not yet supported!");
        }
        if (strokeAttributes.StartCapType == 0) {
            n = 0;
        } else if (strokeAttributes.StartCapType == 1) {
            n = 1;
        } else if (strokeAttributes.StartCapType == 2) {
            n = 2;
        }
        int n2 = 0;
        if (strokeAttributes.JoinType == 1) {
            n = 0;
        } else if (strokeAttributes.JoinType == 2) {
            n = 1;
        } else if (strokeAttributes.JoinType == 3) {
            n = 2;
        } else {
            CanvasUtils.printLog("applyStrokeAttributes: current join type not yet supported!");
        }
        float[] fArray = null;
        if (strokeAttributes.DashArray.length != 0) {
            fArray = new float[strokeAttributes.DashArray.length];
            for (int i = 0; i < strokeAttributes.DashArray.length; ++i) {
                fArray[i] = (float)strokeAttributes.DashArray[i];
            }
        }
        graphics2D.setStroke(new BasicStroke((float)strokeAttributes.StrokeWidth, n, n2, (float)strokeAttributes.MiterLimit, fArray, 0.0f));
    }

    public static void setupGraphicsFont(Graphics2D graphics2D, ViewState viewState, RenderState renderState, XCanvasFont xCanvasFont) {
        if (xCanvasFont instanceof CanvasFont) {
            CanvasUtils.printLog("setupGraphicsFont: font impl used.");
            graphics2D.setFont(((CanvasFont)xCanvasFont).getFont());
        } else {
            CanvasUtils.printLog("setupGraphicsFont: creating Java font anew.");
            CanvasFont canvasFont = new CanvasFont(xCanvasFont.getFontRequest(), null);
            graphics2D.setFont(canvasFont.getFont());
        }
    }

    static Rectangle2D.Double calcTransformedRectBounds(Rectangle2D.Double double_, AffineTransform affineTransform) {
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        affineTransform.transform(double_2, double_2);
        Point2D.Double double_3 = new Point2D.Double(double_.x + double_.width, double_.y);
        affineTransform.transform(double_3, double_3);
        Point2D.Double double_4 = new Point2D.Double(double_.x, double_.y + double_.height);
        affineTransform.transform(double_4, double_4);
        Point2D.Double double_5 = new Point2D.Double(double_.x + double_.width, double_.y + double_.height);
        affineTransform.transform(double_5, double_5);
        Point2D.Double double_6 = new Point2D.Double(Math.min(double_2.x, Math.min(double_3.x, Math.min(double_4.x, double_5.x))), Math.min(double_2.y, Math.min(double_3.y, Math.min(double_4.y, double_5.y))));
        Point2D.Double double_7 = new Point2D.Double(Math.max(double_2.x, Math.max(double_3.x, Math.max(double_4.x, double_5.x))), Math.max(double_2.y, Math.max(double_3.y, Math.max(double_4.y, double_5.y))));
        return new Rectangle2D.Double(double_6.x, double_6.y, double_7.x - double_6.x, double_7.y - double_6.y);
    }

    public static ViewState createAnimationViewState(ViewState viewState, AnimationAttributes animationAttributes) {
        AffineTransform affineTransform = CanvasUtils.makeTransform(viewState.AffineTransform);
        Rectangle2D.Double double_ = CanvasUtils.calcTransformedRectBounds(new Rectangle2D.Double(0.0, 0.0, animationAttributes.UntransformedSize.Width, animationAttributes.UntransformedSize.Height), affineTransform);
        CanvasUtils.printTransform(affineTransform, "createAnimationViewState");
        CanvasUtils.printLog("createAnimationViewState: transformed origin is: (" + double_.x + ", " + double_.y + ")");
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(-double_.x, -double_.y);
        affineTransform2.concatenate(affineTransform);
        CanvasUtils.printTransform(affineTransform2, "createAnimationViewState");
        return new ViewState(CanvasUtils.makeAffineMatrix2D(affineTransform2), viewState.Clip);
    }

    public static void postRenderImageTreatment(Image image) {
        image.flush();
    }

    public static void printTransform(AffineTransform affineTransform, String string) {
        CanvasUtils.printLog(string + ": Transform is");
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        for (int i = 0; i < 6; ++i) {
            System.err.print(dArray[i] + ", ");
        }
        CanvasUtils.printLog("");
    }

    public static void preCondition(boolean bl, String string) {
        if (!bl) {
            CanvasUtils.printLog("Precondition violated: " + string);
        }
    }

    public static void printLog(String string) {
        System.err.println(string);
    }
}

