/*
 * Decompiled with CFR 0.152.
 */
import com.sun.star.geometry.AffineMatrix2D;
import com.sun.star.geometry.RealPoint2D;
import com.sun.star.geometry.RealSize2D;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.ComponentBase;
import com.sun.star.rendering.AnimationAttributes;
import com.sun.star.rendering.RenderState;
import com.sun.star.rendering.ViewState;
import com.sun.star.rendering.XAnimatedSprite;
import com.sun.star.rendering.XAnimation;
import com.sun.star.rendering.XPolyPolygon2D;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class CanvasSprite
extends ComponentBase
implements XAnimatedSprite,
XServiceInfo,
SpriteBase {
    private XAnimation spriteAnimation;
    private JavaCanvas canvas;
    private Graphics2D referenceGraphics;
    private SpriteRunner runner;
    private ViewState viewState;
    private double alpha;
    private Point2D.Double outputPosition;
    private SpriteRep spriteRep;
    private static final String s_implName = "XSprite.java.impl";
    private static final String s_serviceName = "com.sun.star.rendering.Sprite";

    public CanvasSprite(XAnimation xAnimation, JavaCanvas javaCanvas, Graphics2D graphics2D) {
        CanvasUtils.printLog("CanvasSprite constructor called!");
        this.spriteAnimation = xAnimation;
        this.canvas = javaCanvas;
        this.referenceGraphics = graphics2D;
        this.alpha = 0.0;
        this.outputPosition = new Point2D.Double(0.0, 0.0);
        this.runner = new SpriteRunner(this, this.spriteAnimation, this.canvas);
    }

    public synchronized ViewState getViewState() {
        return this.viewState;
    }

    @Override
    public synchronized SpriteRep getSpriteRep() {
        if (this.spriteRep == null) {
            this.spriteRep = new SpriteRep();
            this.setupSpriteBuffering(CanvasUtils.makeTransform(this.getViewState().AffineTransform));
            this.spriteRep.moveSprite(this.outputPosition);
            this.spriteRep.setSpriteAlpha(this.alpha);
            this.updateAnimation();
        }
        return this.spriteRep;
    }

    public void dispose() {
        if (this.runner != null) {
            this.runner.quit();
            try {
                this.runner.join(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.spriteRep != null) {
            this.spriteRep.dispose();
        }
        this.canvas = null;
        this.spriteAnimation = null;
        this.runner = null;
        this.referenceGraphics = null;
        this.spriteRep = null;
        super.dispose();
    }

    public synchronized void startAnimation(double d) {
        this.runner.startAnimation(d);
    }

    public synchronized void stopAnimation() {
        this.runner.stopAnimation();
    }

    public synchronized void resetAnimation() {
        this.runner.resetAnimation();
    }

    public synchronized void updateAnimation() {
        if (this.spriteRep != null && !this.runner.isAnimationActive()) {
            this.spriteRep.renderAnimation(this.spriteAnimation, this.getViewState(), this.runner.getCurrentT());
        }
    }

    public synchronized void setPriority(double d) {
    }

    public synchronized void setAlpha(double d) {
        this.alpha = d;
        if (this.spriteRep != null) {
            this.spriteRep.setSpriteAlpha(this.alpha);
        }
    }

    public synchronized void move(RealPoint2D realPoint2D, ViewState viewState, RenderState renderState) {
        AffineTransform affineTransform = CanvasUtils.ViewConcatRenderTransform(viewState, renderState);
        affineTransform.transform(new Point2D.Double(realPoint2D.X, realPoint2D.Y), this.outputPosition);
        if (this.spriteRep != null) {
            this.spriteRep.moveSprite(this.outputPosition);
        }
    }

    public synchronized void transform(AffineMatrix2D affineMatrix2D) throws IllegalArgumentException {
    }

    public synchronized void clip(XPolyPolygon2D xPolyPolygon2D) {
    }

    public synchronized void show() {
        this.canvas.showSprite(this);
        this.canvas.updateScreen(false);
    }

    public synchronized void hide() {
        this.canvas.hideSprite(this);
        if (this.spriteRep != null) {
            this.spriteRep.dispose();
        }
        this.spriteRep = null;
    }

    public synchronized void setViewState(ViewState viewState) {
        this.viewState = CanvasUtils.createAnimationViewState(viewState, this.getAnimationAttributes());
        CanvasUtils.printTransform(CanvasUtils.makeTransform(this.viewState.AffineTransform), "CanvasSprite.setViewState");
        if (this.spriteRep != null) {
            this.setupSpriteBuffering(CanvasUtils.makeTransform(this.getViewState().AffineTransform));
            this.updateAnimation();
        }
    }

    public synchronized AnimationAttributes getAnimationAttributes() {
        return this.spriteAnimation.getAnimationAttributes();
    }

    public synchronized void setAll(RealPoint2D realPoint2D, ViewState viewState, RenderState renderState, double d, boolean bl) {
        this.alpha = d;
        AffineTransform affineTransform = CanvasUtils.ViewConcatRenderTransform(viewState, renderState);
        affineTransform.transform(new Point2D.Double(realPoint2D.X, realPoint2D.Y), this.outputPosition);
        if (this.spriteRep != null) {
            this.spriteRep.setSpriteAlpha(this.alpha);
            this.spriteRep.moveSprite(this.outputPosition);
            if (bl) {
                this.updateAnimation();
            }
        }
    }

    private void setupSpriteBuffering(AffineTransform affineTransform) {
        RealSize2D realSize2D = this.getAnimationAttributes().UntransformedSize;
        Rectangle2D.Double double_ = CanvasUtils.calcTransformedRectBounds(new Rectangle2D.Double(0.0, 0.0, realSize2D.Width, realSize2D.Height), affineTransform);
        CanvasUtils.printTransform(affineTransform, "setupSpriteBuffering");
        CanvasUtils.printLog("setupSpriteBuffering: bounds are (" + double_.width + ", " + double_.height + ")");
        this.spriteRep.setupBuffer(this.referenceGraphics, (int)(double_.width + 0.5), (int)(double_.height + 0.5));
    }

    public String getImplementationName() {
        return s_implName;
    }

    public String[] getSupportedServiceNames() {
        return new String[]{s_serviceName};
    }

    public boolean supportsService(String string) {
        return string.equals(s_serviceName);
    }
}

