/*
 * Decompiled with CFR 0.152.
 */
import com.sun.star.geometry.AffineMatrix2D;
import com.sun.star.geometry.RealPoint2D;
import com.sun.star.geometry.RealSize2D;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.ComponentBase;
import com.sun.star.rendering.RenderState;
import com.sun.star.rendering.ViewState;
import com.sun.star.rendering.XCanvas;
import com.sun.star.rendering.XCustomSprite;
import com.sun.star.rendering.XPolyPolygon2D;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class CanvasCustomSprite
extends ComponentBase
implements XCustomSprite,
XServiceInfo,
SpriteBase {
    private JavaCanvas canvas;
    private RealSize2D spriteSize;
    private Graphics2D referenceGraphics;
    private double alpha;
    private Point2D.Double outputPosition;
    private SpriteRep spriteRep;
    private static final String s_implName = "XCustomSprite.java.impl";
    private static final String s_serviceName = "com.sun.star.rendering.CustomSprite";

    public CanvasCustomSprite(RealSize2D realSize2D, JavaCanvas javaCanvas, Graphics2D graphics2D) {
        CanvasUtils.printLog("CanvasCustomSprite constructor called, size is (" + realSize2D.Width + ", " + realSize2D.Height + ")");
        this.canvas = javaCanvas;
        this.spriteSize = realSize2D;
        this.referenceGraphics = graphics2D;
        this.alpha = 0.0;
        this.outputPosition = new Point2D.Double(0.0, 0.0);
    }

    @Override
    public synchronized SpriteRep getSpriteRep() {
        if (this.spriteRep == null) {
            this.spriteRep = new SpriteRep();
            this.spriteRep.setupBuffer(this.referenceGraphics, (int)(this.spriteSize.Width + 0.5), (int)(this.spriteSize.Height + 0.5));
            this.spriteRep.moveSprite(this.outputPosition);
            this.spriteRep.setSpriteAlpha(this.alpha);
        }
        return this.spriteRep;
    }

    public void dispose() {
        if (this.spriteRep != null) {
            this.spriteRep.dispose();
        }
        this.canvas = null;
        this.referenceGraphics = null;
        this.spriteRep = null;
        super.dispose();
    }

    public synchronized void setPriority(double d) {
    }

    public synchronized void setAlpha(double d) {
        CanvasUtils.printLog("CanvasCustomSprite.setAlpha() called");
        this.alpha = d;
        if (this.spriteRep != null) {
            this.spriteRep.setSpriteAlpha(this.alpha);
        }
    }

    public synchronized void move(RealPoint2D realPoint2D, ViewState viewState, RenderState renderState) {
        CanvasUtils.printLog("CanvasCustomSprite.move() called");
        AffineTransform affineTransform = CanvasUtils.ViewConcatRenderTransform(viewState, renderState);
        affineTransform.transform(new Point2D.Double(realPoint2D.X, realPoint2D.Y), this.outputPosition);
        if (this.spriteRep != null) {
            this.spriteRep.moveSprite(this.outputPosition);
        }
    }

    public synchronized void transform(AffineMatrix2D affineMatrix2D) throws IllegalArgumentException {
    }

    public synchronized void clip(XPolyPolygon2D xPolyPolygon2D) {
    }

    public synchronized void show() {
        CanvasUtils.printLog("CanvasCustomSprite.show() called");
        this.canvas.showSprite(this);
        this.canvas.updateScreen(false);
    }

    public synchronized void hide() {
        CanvasUtils.printLog("CanvasCustomSprite.hide() called");
        this.canvas.hideSprite(this);
    }

    public synchronized XCanvas getContentCanvas() {
        CanvasUtils.printLog("CanvasCustomSprite.getContentCanvas() called");
        return this.getSpriteRep().getContentCanvas();
    }

    public String getImplementationName() {
        return s_implName;
    }

    public String[] getSupportedServiceNames() {
        return new String[]{s_serviceName};
    }

    public boolean supportsService(String string) {
        return string.equals(s_serviceName);
    }
}

