/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.reportbuilder;

import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.report.XReportDefinition;
import com.sun.star.sdbc.XConnection;
import com.sun.star.ucb.Command;
import com.sun.star.ucb.OpenCommandArgument2;
import com.sun.star.ucb.XCommandProcessor;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XModeSelector;
import com.sun.star.util.XURLTransformer;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.RecordParser;
import com.sun.star.wizards.report.IReportBuilderLayouter;
import com.sun.star.wizards.report.IReportDefinitionReadAccess;
import com.sun.star.wizards.report.IReportDocument;
import com.sun.star.wizards.report.ReportImplementationHelper;
import com.sun.star.wizards.report.ReportWizard;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;

public class ReportBuilderImplementation
extends ReportImplementationHelper
implements IReportDocument,
IReportDefinitionReadAccess {
    private static final int MAXIMUM_GROUPCOUNT = 4;
    private Resource m_aResource;
    private XFrame m_xFrame = null;
    private String m_sReportBuilderLayoutName = "";
    private Object m_aReportDocument;
    private XPropertySet m_aDocumentDefinition;
    private XReportDefinition m_xReportDefinition;
    private ArrayList m_aReportPath;
    private LinkedHashMap m_aLayoutMap = null;
    private String m_sDefaultHeaderLayoutPath;

    @Override
    public void clearDocument() {
    }

    public ReportBuilderImplementation() {
        super(null, 30);
        this.m_aResource = null;
    }

    private ReportBuilderImplementation(XMultiServiceFactory xMultiServiceFactory, Resource resource) {
        super(xMultiServiceFactory, 30);
        this.m_aResource = resource;
    }

    public static IReportDocument create(XMultiServiceFactory xMultiServiceFactory, Resource resource) {
        ReportBuilderImplementation reportBuilderImplementation = new ReportBuilderImplementation(xMultiServiceFactory, resource);
        return reportBuilderImplementation;
    }

    @Override
    public XWindowPeer getWizardParent() {
        XWindowPeer xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.getFrame().getComponentWindow());
        return xWindowPeer;
    }

    private IReportBuilderLayouter getReportBuilderLayouter() {
        IReportBuilderLayouter iReportBuilderLayouter = (IReportBuilderLayouter)this.getLayoutMap().get(this.m_sReportBuilderLayoutName);
        return iReportBuilderLayouter;
    }

    private void initialize(Object object, XConnection xConnection) {
        this.m_aReportDocument = object;
        Object[] objectArray = new Object[2];
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "ClassID";
        propertyValue.Value = "d7896d52-b7af-4820-9dfe-d404d015960f";
        objectArray[0] = propertyValue;
        PropertyValue propertyValue2 = new PropertyValue();
        propertyValue2.Name = "ActiveConnection";
        propertyValue2.Value = xConnection;
        objectArray[1] = propertyValue2;
        XReportDefinition xReportDefinition = null;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)object);
        try {
            XPropertySet xPropertySet;
            Object object2 = xMultiServiceFactory.createInstanceWithArguments("com.sun.star.sdb.DocumentDefinition", objectArray);
            this.m_aDocumentDefinition = xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object2);
            XCommandProcessor xCommandProcessor = (XCommandProcessor)UnoRuntime.queryInterface(XCommandProcessor.class, (Object)object2);
            Command command = new Command();
            command.Name = "openDesign";
            OpenCommandArgument2 openCommandArgument2 = new OpenCommandArgument2();
            openCommandArgument2.Mode = 2;
            PropertyValue[] propertyValueArray = new PropertyValue[2];
            PropertyValue propertyValue3 = new PropertyValue();
            propertyValue3.Name = "";
            propertyValue3.Value = openCommandArgument2;
            propertyValueArray[0] = propertyValue3;
            PropertyValue propertyValue4 = new PropertyValue();
            propertyValue4.Name = "Mode";
            propertyValue4.Value = "remote";
            propertyValueArray[1] = propertyValue4;
            command.Argument = propertyValueArray;
            Object object3 = xCommandProcessor.execute(command, xCommandProcessor.createCommandIdentifier(), null);
            xReportDefinition = (XReportDefinition)UnoRuntime.queryInterface(XReportDefinition.class, (Object)object3);
        }
        catch (com.sun.star.uno.Exception exception) {
            ReportWizard.getLogger().log(1000, "Problems with initialize the ReportDefinition" + exception.getMessage());
        }
        this.m_xReportDefinition = xReportDefinition;
        this.switchOffPropertyBrowser();
        this.switchOffAddFieldWindow();
        this.setPageOrientation(this.m_nDefaultPageOrientation, false);
    }

    private XModeSelector getModeSelector() {
        XController xController = this.getReportDefinition().getCurrentController();
        XModeSelector xModeSelector = (XModeSelector)UnoRuntime.queryInterface(XModeSelector.class, (Object)xController);
        return xModeSelector;
    }

    private void switchOffAddFieldWindow() {
        try {
            this.getModeSelector().setMode("remote");
        }
        catch (com.sun.star.uno.Exception exception) {
            boolean bl = false;
        }
    }

    private void switchOnAddFieldWindow() {
        try {
            this.getModeSelector().setMode("normal");
        }
        catch (com.sun.star.uno.Exception exception) {
            boolean bl = false;
        }
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void switchOffPropertyBrowser() {
        try {
            XController xController = this.getReportDefinition().getCurrentController();
            XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
            Object object = this.getMSF().createInstance("com.sun.star.util.URLTransformer");
            XURLTransformer xURLTransformer = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, (Object)object);
            URL[] uRLArray = new URL[]{new URL()};
            uRLArray[0].Complete = ".uno:ControlProperties";
            xURLTransformer.parseStrict(uRLArray);
            XDispatch xDispatch = xDispatchProvider.queryDispatch(uRLArray[0], "_self", 0);
            PropertyValue[] propertyValueArray = new PropertyValue[]{};
            xDispatch.dispatch(uRLArray[0], propertyValueArray);
        }
        catch (com.sun.star.uno.Exception exception) {
            boolean bl = false;
        }
    }

    private void switchOnPropertyBrowser() {
        this.switchOffPropertyBrowser();
    }

    @Override
    public XFrame getFrame() {
        if (this.m_xFrame == null) {
            this.initialize(this.getRecordParser().getReportDocuments(), this.getConnection());
            this.m_xFrame = this.getReportDefinition().getCurrentController().getFrame();
            this.setPageOrientation(this.m_nDefaultPageOrientation, true);
        }
        return this.m_xFrame;
    }

    @Override
    public boolean reconnectToDatabase(XMultiServiceFactory xMultiServiceFactory, PropertyValue[] propertyValueArray) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void insertDatabaseDatatoReportDocument(XMultiServiceFactory xMultiServiceFactory) {
    }

    @Override
    public void StopProcess() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void store(String string, int n) {
        if (n == 1) {
            return;
        }
        try {
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.m_aReportDocument);
            String[] stringArray = xNameAccess.getElementNames();
            XCommandProcessor xCommandProcessor = (XCommandProcessor)UnoRuntime.queryInterface(XCommandProcessor.class, (Object)this.m_aDocumentDefinition);
            Command command = new Command();
            command.Name = "storeOwn";
            Object object = xCommandProcessor.execute(command, xCommandProcessor.createCommandIdentifier(), null);
            XNameContainer xNameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)this.m_aReportDocument);
            xNameContainer.insertByName(string, (Object)this.m_aDocumentDefinition);
        }
        catch (Exception exception) {
            boolean bl = false;
        }
    }

    @Override
    public boolean liveupdate_addGroupNametoDocument(String[] stringArray, String string, Vector vector, ArrayList arrayList, int n) {
        int n2 = vector.size();
        if (n2 < 4) {
            FieldColumn fieldColumn = this.getRecordParser().getFieldColumnByTitle(string);
            vector.addElement(fieldColumn.getFieldName());
        }
        return true;
    }

    @Override
    public void refreshGroupFields(String[] stringArray) {
    }

    @Override
    public void liveupdate_removeGroupName(String[] stringArray, String string, Vector vector) {
        FieldColumn fieldColumn = this.getRecordParser().getFieldColumnByTitle(string);
        vector.removeElement(fieldColumn.getFieldName());
    }

    private void setPageOrientation(int n, boolean bl) {
        this.getReportBuilderLayouter().setPageOrientation(n);
        if (bl) {
            this.getReportBuilderLayouter().layout();
        }
    }

    @Override
    public void setPageOrientation(int n) {
        this.setPageOrientation(n, true);
    }

    @Override
    public void liveupdate_changeLayoutTemplate(String string) {
        IReportBuilderLayouter iReportBuilderLayouter = this.getReportBuilderLayouter();
        iReportBuilderLayouter.loadAndSetBackgroundTemplate(string);
        iReportBuilderLayouter.layout();
    }

    public void setReportBuilderLayouterName(String string) {
        IReportBuilderLayouter iReportBuilderLayouter = this.getReportBuilderLayouter();
        IReportBuilderLayouter iReportBuilderLayouter2 = (IReportBuilderLayouter)this.m_aLayoutMap.get(string);
        if (iReportBuilderLayouter2 != null) {
            this.m_sReportBuilderLayoutName = string;
            iReportBuilderLayouter2.initializeData(iReportBuilderLayouter);
            iReportBuilderLayouter2.layout();
        }
    }

    @Override
    public void liveupdate_changeContentTemplate(String string) {
        this.setReportBuilderLayouterName(string);
    }

    @Override
    public void layout_setupRecordSection(String string) {
    }

    @Override
    public void removeTextTableAndTextSection() {
    }

    @Override
    public void layout_selectFirstPage() {
    }

    @Override
    public void dispose() {
        this.getReportBuilderLayouter().dispose();
        try {
            XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.m_aDocumentDefinition);
            xComponent.dispose();
            this.m_xReportDefinition = null;
        }
        catch (Exception exception) {
            boolean bl = false;
        }
    }

    @Override
    public XComponent getComponent() {
        return null;
    }

    @Override
    public void liveupdate_changeUserFieldContent(String string, String string2) {
    }

    @Override
    public void liveupdate_updateReportTitle(String string) {
    }

    @Override
    public void addReportToDBView() {
    }

    private XComponent[] createFinalReportDocument(String string, Object object, boolean bl, boolean bl2) {
        XComponent[] xComponentArray = new XComponent[1];
        try {
            PropertyValue[] propertyValueArray = new PropertyValue[2];
            propertyValueArray[0] = new PropertyValue();
            propertyValueArray[0].Name = "ActiveConnection";
            propertyValueArray[0].Value = object;
            OpenCommandArgument2 openCommandArgument2 = new OpenCommandArgument2();
            openCommandArgument2.Mode = 2;
            propertyValueArray[1] = new PropertyValue();
            propertyValueArray[1].Name = "OpenCommand";
            propertyValueArray[1].Value = openCommandArgument2;
            XCommandProcessor xCommandProcessor = (XCommandProcessor)UnoRuntime.queryInterface(XCommandProcessor.class, (Object)this.m_aDocumentDefinition);
            Command command = new Command();
            command.Name = "open";
            command.Argument = propertyValueArray;
            Object object2 = xCommandProcessor.execute(command, xCommandProcessor.createCommandIdentifier(), null);
            xComponentArray[0] = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)object2);
        }
        catch (com.sun.star.uno.Exception exception) {
            boolean bl3 = false;
        }
        return xComponentArray;
    }

    @Override
    public XComponent[] createFinalReportDocument(String string, boolean bl, boolean bl2) {
        if (bl && !bl2) {
            XComponent[] xComponentArray = this.createFinalReportDocument(string, this.getRecordParser().DBConnection, bl, bl2);
            this.dispose();
            return xComponentArray;
        }
        if (!bl) {
            XComponent[] xComponentArray = this.createFinalReportDocument(string, this.getRecordParser().DBConnection, bl, bl2);
            boolean bl3 = this.getRecordParser().storeDatabaseDocumentToTempPath(xComponentArray[0], string);
            if (bl3) {
                this.getRecordParser().addReportDocument(xComponentArray[0], false);
            }
            this.dispose();
        } else {
            this.switchOnAddFieldWindow();
            this.switchOnPropertyBrowser();
        }
        return null;
    }

    private XConnection getConnection() {
        return this.getRecordParser().DBConnection;
    }

    @Override
    public void initializeFieldColumns(int n, String string, String[] stringArray) {
        this.getRecordParser().initializeFieldColumns(stringArray, string);
        RecordParser recordParser = this.getRecordParser();
        int[] nArray = new int[stringArray.length];
        int[] nArray2 = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = recordParser.FieldColumns[i].getFieldType();
            nArray2[i] = recordParser.FieldColumns[i].getFieldWidth();
        }
        this.getReportBuilderLayouter().setTableName(n, string);
        this.getReportBuilderLayouter().insertFieldNames(stringArray);
        this.getReportBuilderLayouter().insertFieldTypes(nArray);
        this.getReportBuilderLayouter().insertFieldWidths(nArray2);
        this.getReportBuilderLayouter().layout();
    }

    @Override
    public void setFieldTitles(String[] stringArray) {
        this.getRecordParser().setFieldTitles(stringArray);
        this.getReportBuilderLayouter().insertFieldTitles(stringArray);
        this.getReportBuilderLayouter().layout();
    }

    @Override
    public void setSorting(String[][] stringArray) {
        this.getRecordParser().setSortFieldNames(stringArray);
    }

    @Override
    public void setGrouping(String[] stringArray) {
        this.getRecordParser().prependSortFieldNames(stringArray);
        this.getReportBuilderLayouter().insertGroupNames(stringArray);
        this.getReportBuilderLayouter().layout();
    }

    @Override
    public String getLayoutPath() {
        return "default";
    }

    @Override
    public ArrayList getReportPath() {
        if (this.m_aReportPath == null) {
            try {
                this.m_aReportPath = FileAccess.getOfficePaths(this.getMSF(), "Template", "share", "/wizard");
                FileAccess.combinePaths(this.getMSF(), this.m_aReportPath, "/wizard/report");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_aReportPath;
    }

    @Override
    public String getContentPath() {
        return "";
    }

    @Override
    public int getDefaultPageOrientation() {
        return this.m_nDefaultPageOrientation;
    }

    private IReportBuilderLayouter getLayoutInstanceFrom(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(IReportDefinitionReadAccess.class, Resource.class);
            Object[] objectArray = new Object[]{this, this.m_aResource};
            IReportBuilderLayouter iReportBuilderLayouter = (IReportBuilderLayouter)constructor.newInstance(objectArray);
            return iReportBuilderLayouter;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void insertIntoLayoutMap(IReportBuilderLayouter iReportBuilderLayouter) {
        this.insertIntoLayoutMap(iReportBuilderLayouter, false);
    }

    private void insertIntoLayoutMap(IReportBuilderLayouter iReportBuilderLayouter, boolean bl) {
        if (iReportBuilderLayouter != null) {
            String string = iReportBuilderLayouter.getName();
            if (bl) {
                this.m_sReportBuilderLayoutName = string;
            }
            this.m_aLayoutMap.put(string, iReportBuilderLayouter);
        }
    }

    private LinkedHashMap getLayoutMap() {
        if (this.m_aLayoutMap == null) {
            this.m_aLayoutMap = new LinkedHashMap();
            IReportBuilderLayouter iReportBuilderLayouter = this.getLayoutInstanceFrom("com.sun.star.wizards.reportbuilder.layout.Tabular");
            this.insertIntoLayoutMap(iReportBuilderLayouter, true);
            iReportBuilderLayouter = this.getLayoutInstanceFrom("com.sun.star.wizards.reportbuilder.layout.ColumnarSingleColumn");
            this.insertIntoLayoutMap(iReportBuilderLayouter);
            iReportBuilderLayouter = this.getLayoutInstanceFrom("com.sun.star.wizards.reportbuilder.layout.ColumnarTwoColumns");
            this.insertIntoLayoutMap(iReportBuilderLayouter);
            iReportBuilderLayouter = this.getLayoutInstanceFrom("com.sun.star.wizards.reportbuilder.layout.ColumnarThreeColumns");
            this.insertIntoLayoutMap(iReportBuilderLayouter);
            iReportBuilderLayouter = this.getLayoutInstanceFrom("com.sun.star.wizards.reportbuilder.layout.InBlocksLabelsAbove");
            this.insertIntoLayoutMap(iReportBuilderLayouter);
            iReportBuilderLayouter = this.getLayoutInstanceFrom("com.sun.star.wizards.reportbuilder.layout.InBlocksLabelsLeft");
            this.insertIntoLayoutMap(iReportBuilderLayouter);
        }
        return this.m_aLayoutMap;
    }

    @Override
    public String[][] getDataLayout() {
        String[][] stringArray = new String[2][];
        String[] stringArray2 = new String[this.getLayoutMap().size()];
        String[] stringArray3 = new String[this.getLayoutMap().size()];
        Set set = this.getLayoutMap().keySet();
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string;
            stringArray2[n] = string = (String)iterator.next();
            IReportBuilderLayouter iReportBuilderLayouter = (IReportBuilderLayouter)this.m_aLayoutMap.get(string);
            stringArray3[n++] = iReportBuilderLayouter.getLocalizedName();
        }
        stringArray[1] = stringArray2;
        stringArray[0] = stringArray3;
        return stringArray;
    }

    @Override
    public String[][] getHeaderLayout() {
        String[][] stringArray;
        try {
            ArrayList<String> arrayList = FileAccess.getOfficePaths(this.getMSF(), "Template", "share", "/wizard");
            FileAccess.combinePaths(this.getMSF(), arrayList, "/wizard/report");
            stringArray = FileAccess.getFolderTitles(this.getMSF(), null, arrayList, ".otr");
        }
        catch (NoValidPathException noValidPathException) {
            stringArray = new String[2][];
            String[] stringArray2 = new String[1];
            String[] stringArray3 = new String[1];
            stringArray2[0] = "DefaultLayoutOfHeaders";
            stringArray3[0] = "default";
            stringArray[1] = stringArray2;
            stringArray[0] = stringArray3;
        }
        for (int i = 0; i < stringArray[0].length; ++i) {
            if (!stringArray[0][i].equals("default")) continue;
            this.m_sDefaultHeaderLayoutPath = stringArray[1][i];
            break;
        }
        return stringArray;
    }

    @Override
    public XReportDefinition getReportDefinition() {
        if (this.m_xReportDefinition == null) {
            throw new NullPointerException("Report Definition is not already initialized, check if you too early access the report definition.");
        }
        return this.m_xReportDefinition;
    }

    @Override
    public XMultiServiceFactory getGlobalMSF() {
        return this.getMSF();
    }

    @Override
    public void importReportData(ReportWizard reportWizard) {
    }

    @Override
    public String getDefaultHeaderLayout() {
        return this.m_sDefaultHeaderLayoutPath;
    }

    @Override
    public void setCommand(String string) {
        this.getRecordParser().Command = string;
        this.getReportDefinition().setCommand(string);
    }

    @Override
    public void setCommandType(int n) {
        this.getReportDefinition().setCommandType(n);
    }

    @Override
    public void checkInvariants() throws Exception {
        String string = this.getDefaultHeaderLayout();
        if (string == null) {
            throw new IOException("default.otr");
        }
        String string2 = FileAccess.getFilename(string);
        FileAccess fileAccess = new FileAccess(this.getGlobalMSF());
        if (!fileAccess.exists(string, true)) {
            throw new IOException("default.otr");
        }
    }
}

