/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.Dialog;
import org.openoffice.java.accessibility.Frame;
import org.openoffice.java.accessibility.NativeFrame;

public class Window
extends java.awt.Window
implements Accessible,
NativeFrame {
    protected XAccessibleComponent unoAccessibleComponent;
    boolean opened = false;
    boolean visible = false;
    EventQueue eventQueue = null;
    Component initialComponent = null;
    protected AccessibleContext accessibleContext = null;

    public Window(java.awt.Window window, XAccessibleComponent xAccessibleComponent) {
        super(window);
        this.initialize(xAccessibleComponent);
    }

    private void initialize(XAccessibleComponent xAccessibleComponent) {
        this.unoAccessibleComponent = xAccessibleComponent;
        this.eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        XAccessibleEventBroadcaster xAccessibleEventBroadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface(XAccessibleEventBroadcaster.class, (Object)this.unoAccessibleComponent);
        if (xAccessibleEventBroadcaster != null) {
            xAccessibleEventBroadcaster.addEventListener((XAccessibleEventListener)new AccessibleWindowListener());
        }
    }

    @Override
    public Component getInitialComponent() {
        return this.initialComponent;
    }

    @Override
    public void setInitialComponent(Component component) {
        this.initialComponent = component;
    }

    public Integer getHWND() {
        return null;
    }

    @Override
    public boolean isShowing() {
        if (this.isVisible()) {
            Container container = this.getParent();
            return container == null || container.isShowing();
        }
        return false;
    }

    @Override
    public void addNotify() {
    }

    @Override
    public void removeNotify() {
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            if (bl) {
                if (!this.opened) {
                    this.postWindowEvent(200);
                    this.opened = true;
                }
                this.postComponentEvent(102);
            } else {
                this.postComponentEvent(103);
            }
        }
    }

    @Override
    public void dispose() {
        this.setVisible(false);
        this.postWindowEvent(202);
        if (this.getOwner() instanceof Frame && ((Frame)this.getOwner()).active || this.getOwner() instanceof Dialog && ((Dialog)this.getOwner()).active) {
            this.eventQueue.postEvent(new WindowEvent(this.getOwner(), 207));
        }
    }

    protected void postWindowEvent(int n) {
        this.eventQueue.postEvent(new WindowEvent(this, n));
    }

    protected void postComponentEvent(int n) {
        this.eventQueue.postEvent(new ComponentEvent(this, n));
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleWindow();
        }
        return this.accessibleContext;
    }

    protected class AccessibleWindow
    extends Window.AccessibleAWTWindow {
        protected ComponentListener accessibleComponentHandler;
        protected ContainerListener accessibleContainerHandler;
        protected int propertyChangeListenerCount;

        protected AccessibleWindow() {
            super(Window.this);
            this.accessibleComponentHandler = null;
            this.accessibleContainerHandler = null;
            this.propertyChangeListenerCount = 0;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListenerCount++ == 0) {
                this.accessibleContainerHandler = new AccessibleContainerHandler();
                Window.this.addContainerListener(this.accessibleContainerHandler);
                this.accessibleComponentHandler = new AccessibleComponentHandler();
                Window.this.addComponentListener(this.accessibleComponentHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (--this.propertyChangeListenerCount == 0) {
                Window.this.removeComponentListener(this.accessibleComponentHandler);
                this.accessibleComponentHandler = null;
                Window.this.removeContainerListener(this.accessibleContainerHandler);
                this.accessibleContainerHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        @Override
        public Color getBackground() {
            try {
                return new Color(Window.this.unoAccessibleComponent.getBackground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public Color getForeground() {
            try {
                return new Color(Window.this.unoAccessibleComponent.getForeground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public void setForeground(Color color) {
        }

        @Override
        public Cursor getCursor() {
            return null;
        }

        @Override
        public void setCursor(Cursor cursor) {
        }

        @Override
        public Font getFont() {
            return null;
        }

        @Override
        public void setFont(Font font) {
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        @Override
        public boolean isEnabled() {
            return Window.this.isEnabled();
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public boolean isVisible() {
            return Window.this.isVisible();
        }

        @Override
        public void setVisible(boolean bl) {
        }

        @Override
        public boolean isShowing() {
            return Window.this.isShowing();
        }

        @Override
        public boolean contains(java.awt.Point point) {
            try {
                return Window.this.unoAccessibleComponent.containsPoint(new Point(point.x, point.y));
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        @Override
        public java.awt.Point getLocationOnScreen() {
            try {
                Point point = Window.this.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public java.awt.Point getLocation() {
            try {
                Point point = Window.this.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public void setLocation(java.awt.Point point) {
        }

        @Override
        public java.awt.Rectangle getBounds() {
            try {
                Rectangle rectangle = Window.this.unoAccessibleComponent.getBounds();
                return new java.awt.Rectangle(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public void setBounds(java.awt.Rectangle rectangle) {
        }

        @Override
        public Dimension getSize() {
            try {
                Size size = Window.this.unoAccessibleComponent.getSize();
                return new Dimension(size.Width, size.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public void setSize(Dimension dimension) {
        }

        @Override
        public Accessible getAccessibleAt(java.awt.Point point) {
            try {
                Component component = AccessibleObjectFactory.getAccessibleComponent(Window.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(point.x, point.y)));
                return (Accessible)((Object)component);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        @Override
        public boolean isFocusTraversable() {
            return Window.this.isFocusable();
        }

        @Override
        public void requestFocus() {
            Window.this.unoAccessibleComponent.grabFocus();
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleWindow.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleWindow.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }
        }

        protected class AccessibleComponentHandler
        implements ComponentListener {
            protected AccessibleComponentHandler() {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                AccessibleWindow.this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                AccessibleWindow.this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
            }
        }
    }

    protected class AccessibleWindowListener
    implements XAccessibleEventListener {
        protected AccessibleWindowListener() {
        }

        protected void setComponentState(short s, boolean bl) {
            switch (s) {
                case 13: {
                    Window.this.postWindowEvent(bl ? 203 : 204);
                    break;
                }
                case 25: 
                case 30: {
                    Window.this.setVisible(bl);
                    break;
                }
            }
        }

        protected void handleNameChangedEvent(Object object) {
            try {
                AccessibleContext accessibleContext = Window.this.accessibleContext;
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleDescriptionChangedEvent(Object object) {
            try {
                if (Window.this.accessibleContext != null) {
                    Window.this.accessibleContext.setAccessibleDescription(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleStateChangedEvent(Object object, Object object2) {
            try {
                if (AnyConverter.isShort((Object)object)) {
                    this.setComponentState(AnyConverter.toShort((Object)object), false);
                }
                if (AnyConverter.isShort((Object)object2)) {
                    this.setComponentState(AnyConverter.toShort((Object)object2), true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleVisibleDataEvent() {
            AccessibleContext accessibleContext = Window.this.accessibleContext;
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleVisibleData", null, null);
            }
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 1: {
                    this.handleNameChangedEvent(accessibleEventObject.NewValue);
                    break;
                }
                case 2: {
                    this.handleDescriptionChangedEvent(accessibleEventObject.NewValue);
                    break;
                }
                case 4: {
                    this.handleStateChangedEvent(accessibleEventObject.OldValue, accessibleEventObject.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                        AccessibleObjectFactory.removeChild(Window.this, accessibleEventObject.OldValue);
                        break;
                    }
                    if (!AnyConverter.isObject((Object)accessibleEventObject.NewValue)) break;
                    AccessibleObjectFactory.addChild((Container)Window.this, accessibleEventObject.NewValue);
                    break;
                }
                case 6: 
                case 10: {
                    this.handleVisibleDataEvent();
                    break;
                }
            }
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

