/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.expressions;

import org.jfree.report.DataSourceException;
import org.jfree.report.expressions.AbstractExpression;
import org.jfree.report.expressions.ReportFormulaContext;
import org.jfree.report.flow.ReportContext;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class FormulaExpression
extends AbstractExpression {
    private transient Formula compiledFormula;
    private String formulaNamespace;
    private String formulaExpression;
    private String formula;

    private synchronized FormulaContext getFormulaContext() {
        ReportContext reportContext = this.getRuntime().getReportContext();
        return reportContext.getFormulaContext();
    }

    public String getFormula() {
        return this.formula;
    }

    public String getFormulaNamespace() {
        return this.formulaNamespace;
    }

    public String getFormulaExpression() {
        return this.formulaExpression;
    }

    public void setFormula(String string) {
        this.formula = string;
        if (string == null) {
            this.formulaNamespace = null;
            this.formulaExpression = null;
        } else {
            int n = string.indexOf(58);
            if (n <= 0 || n + 1 == string.length()) {
                if (string.startsWith("=")) {
                    this.formulaNamespace = "report";
                    this.formulaExpression = string.substring(1);
                } else {
                    this.formulaNamespace = null;
                    this.formulaExpression = null;
                }
            } else {
                this.formulaNamespace = string.substring(0, n);
                this.formulaExpression = string.substring(n + 1);
            }
        }
        this.compiledFormula = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object computeRegularValue() {
        if (this.compiledFormula == null) {
            this.compiledFormula = new Formula(this.formulaExpression);
        }
        ReportFormulaContext reportFormulaContext = new ReportFormulaContext(this.getFormulaContext(), this.getDataRow());
        try {
            this.compiledFormula.initialize((FormulaContext)reportFormulaContext);
            Object object = this.compiledFormula.evaluate();
            reportFormulaContext.setDataRow(null);
            return object;
        }
        catch (Throwable throwable) {
            try {
                reportFormulaContext.setDataRow(null);
                throw throwable;
            }
            catch (Exception exception) {
                DebugLog.log((Object)"Failed to compute the regular value.", (Throwable)exception);
                return null;
            }
        }
    }

    public Formula getCompiledFormula() throws ParseException {
        if (this.compiledFormula == null) {
            this.compiledFormula = new Formula(this.formulaExpression);
        }
        return this.compiledFormula;
    }

    @Override
    public Object computeValue() throws DataSourceException {
        try {
            return this.computeRegularValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FormulaExpression formulaExpression = (FormulaExpression)super.clone();
        if (this.compiledFormula != null) {
            formulaExpression.compiledFormula = (Formula)this.compiledFormula.clone();
        }
        return formulaExpression;
    }
}

