/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class BeginningOfFile
implements BIFFRecord {
    private byte[] version = new byte[2];
    private byte[] subStream = new byte[2];

    public BeginningOfFile(boolean bl) {
        this.setVersion((short)271);
        if (bl) {
            this.setSubStreamWBGlobal();
        } else {
            this.setSubStreamWorkSheet();
        }
    }

    public BeginningOfFile(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    private void setVersion(short s) {
        this.version = EndianConverter.writeShort((short)s);
    }

    int getVersion() {
        return EndianConverter.readShort((byte[])this.version);
    }

    private void setSubStreamWBGlobal() {
        this.subStream = EndianConverter.writeShort((short)5);
    }

    private void setSubStreamWorkSheet() {
        this.subStream = EndianConverter.writeShort((short)16);
    }

    int getSubStreamType() {
        return EndianConverter.readShort((byte[])this.subStream);
    }

    @Override
    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.version);
        Debug.log((int)4, (String)("\tVersion : " + EndianConverter.readShort((byte[])this.version) + " Stream : " + EndianConverter.readShort((byte[])this.subStream)));
        return n += inputStream.read(this.subStream);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.version);
        outputStream.write(this.subStream);
        Debug.log((int)4, (String)"Writing BeginningOfFile record");
    }

    @Override
    public short getBiffType() {
        return 9;
    }
}

