/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.util;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.util.HSSFDateUtil;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class DateUtil {
    private static final Date ISO8001_TIME = new GregorianCalendar().getTime();

    private DateUtil() {
    }

    public static Date normalizeDate(Date date, Type type) {
        return DateUtil.normalizeDate(date, type, true);
    }

    public static Date normalizeDate(Date date, Type type, boolean bl) {
        if (date == null) {
            throw new IllegalArgumentException();
        }
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (bl) {
            BigDecimal bigDecimal = HSSFDateUtil.getExcelDate(date);
            bigDecimal = DateUtil.normalizeDate(bigDecimal, type);
            date = HSSFDateUtil.getJavaDate(bigDecimal);
        }
        if (type.isFlagSet("type.time")) {
            return new Time(date.getTime());
        }
        if (type.isFlagSet("type.date")) {
            return new java.sql.Date(date.getTime());
        }
        if (type.isFlagSet("type.datetime")) {
            return new Date(date.getTime());
        }
        return date;
    }

    public static BigDecimal normalizeDate(BigDecimal bigDecimal, Type type) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException();
        }
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (type.isFlagSet("type.time")) {
            BigDecimal bigDecimal2 = bigDecimal.setScale(40, 0);
            return bigDecimal2.subtract(new BigDecimal(bigDecimal2.intValue()));
        }
        if (type.isFlagSet("type.date")) {
            return NumberUtil.performIntRounding(bigDecimal);
        }
        return bigDecimal;
    }

    public static Date now(LocalizationContext localizationContext) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(localizationContext.getTimeZone(), localizationContext.getLocale());
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTime();
    }

    public static Date createDateTime(int n, int n2, int n3, int n4, int n5, int n6, LocalizationContext localizationContext) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(localizationContext.getTimeZone(), localizationContext.getLocale());
        gregorianCalendar.set(5, n3);
        gregorianCalendar.set(2, n2);
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(14, 0);
        gregorianCalendar.set(11, n4);
        gregorianCalendar.set(12, n5);
        gregorianCalendar.set(13, n6);
        return gregorianCalendar.getTime();
    }

    public static Time createTime(int n, int n2, int n3, LocalizationContext localizationContext) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(localizationContext.getTimeZone(), localizationContext.getLocale());
        gregorianCalendar.setTime(ISO8001_TIME);
        gregorianCalendar.set(14, 0);
        gregorianCalendar.set(11, n);
        gregorianCalendar.set(12, n2);
        gregorianCalendar.set(13, n3);
        return new Time(gregorianCalendar.getTime().getTime());
    }

    public static java.sql.Date createDate(int n, int n2, int n3, LocalizationContext localizationContext) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(localizationContext.getTimeZone(), localizationContext.getLocale());
        gregorianCalendar.set(5, n3);
        gregorianCalendar.set(2, n2 - 1);
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(14, 0);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        return new java.sql.Date(gregorianCalendar.getTime().getTime());
    }

    public static Calendar createCalendar(Date date, LocalizationContext localizationContext) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(localizationContext.getTimeZone(), localizationContext.getLocale());
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }
}

