/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.typing;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Type;

public class StaticArrayCallback
implements ArrayCallback {
    private TypeValuePair[][] backend;
    private int rowCount;
    private int colCount;

    public StaticArrayCallback(ArrayCallback arrayCallback) throws EvaluationException {
        this.rowCount = arrayCallback.getRowCount();
        this.colCount = arrayCallback.getColumnCount();
        this.backend = new TypeValuePair[this.rowCount][this.colCount];
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.colCount; ++j) {
                Type type = arrayCallback.getType(i, j);
                Object object = arrayCallback.getValue(i, j);
                this.backend[i][j] = new TypeValuePair(type, object);
            }
        }
    }

    @Override
    public LValue getRaw(int n, int n2) throws EvaluationException {
        return new StaticValue(this.getValue(n, n2), this.getType(n, n2));
    }

    @Override
    public Object getValue(int n, int n2) throws EvaluationException {
        return this.backend[n][n2].getValue();
    }

    @Override
    public Type getType(int n, int n2) throws EvaluationException {
        return this.backend[n][n2].getType();
    }

    @Override
    public int getColumnCount() {
        return this.colCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }
}

