/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.typing;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.DefaultComparator;
import org.pentaho.reporting.libraries.formula.typing.ExtendedComparator;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeConversionException;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.DateTimeType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;
import org.pentaho.reporting.libraries.formula.typing.sequence.AnyNumberSequence;
import org.pentaho.reporting.libraries.formula.typing.sequence.AnySequence;
import org.pentaho.reporting.libraries.formula.typing.sequence.DefaultNumberSequence;
import org.pentaho.reporting.libraries.formula.typing.sequence.NumberSequence;
import org.pentaho.reporting.libraries.formula.util.DateUtil;
import org.pentaho.reporting.libraries.formula.util.HSSFDateUtil;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class DefaultTypeRegistry
implements TypeRegistry {
    private static final Log logger = LogFactory.getLog(DefaultTypeRegistry.class);
    private static final BigDecimal NUM_TRUE = new BigDecimal("1");
    private static final BigDecimal NUM_FALSE;
    private static final BigDecimal ZERO;
    private FormulaContext context;
    private NumberFormat[] numberFormats;

    @Override
    public ExtendedComparator getComparator(Type type, Type type2) {
        DefaultComparator defaultComparator = new DefaultComparator();
        defaultComparator.inititalize(this.context);
        return defaultComparator;
    }

    @Override
    public Number convertToNumber(Type type, Object object) throws EvaluationException {
        LocalizationContext localizationContext = this.context.getLocalizationContext();
        if (object == null) {
            throw new TypeConversionException();
        }
        boolean bl = type.isFlagSet("type.any");
        if (type.isFlagSet("type.numeric") || bl) {
            if ((type.isFlagSet("type.datetime") || type.isFlagSet("type.time") || type.isFlagSet("type.date") || bl) && object instanceof java.util.Date) {
                BigDecimal bigDecimal = HSSFDateUtil.getExcelDate((java.util.Date)object);
                return DateUtil.normalizeDate(bigDecimal, type);
            }
            if (object instanceof Number) {
                return (Number)object;
            }
        }
        if ((type.isFlagSet("type.logical") || bl) && object instanceof Boolean) {
            if (Boolean.TRUE.equals(object)) {
                return NUM_TRUE;
            }
            return NUM_FALSE;
        }
        if (type.isFlagSet("type.text") || bl) {
            String string = this.computeStringValue(object);
            try {
                return new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                for (Object object2 : localizationContext.getDateFormats(DateTimeType.DATETIME_TYPE)) {
                    try {
                        java.util.Date date = ((DateFormat)object2).parse(string);
                        return HSSFDateUtil.getExcelDate(date);
                    }
                    catch (ParseException parseException) {
                    }
                }
                for (Object object3 : localizationContext.getDateFormats(DateTimeType.DATE_TYPE)) {
                    try {
                        java.util.Date date = ((DateFormat)object3).parse(string);
                        return HSSFDateUtil.getExcelDate(date);
                    }
                    catch (ParseException parseException) {
                    }
                }
                for (DateFormat dateFormat : localizationContext.getDateFormats(DateTimeType.TIME_TYPE)) {
                    try {
                        java.util.Date date = dateFormat.parse(string);
                        return HSSFDateUtil.getExcelDate(date);
                    }
                    catch (ParseException parseException) {
                    }
                }
                for (int i = 0; i < this.numberFormats.length; ++i) {
                    try {
                        NumberFormat numberFormat = this.numberFormats[i];
                        return numberFormat.parse(string);
                    }
                    catch (ParseException parseException) {
                        continue;
                    }
                }
            }
        }
        throw new TypeConversionException();
    }

    public void initialize(Configuration configuration, FormulaContext formulaContext) {
        this.initialize(formulaContext);
    }

    public void initialize(FormulaContext formulaContext) {
        if (formulaContext == null) {
            throw new NullPointerException();
        }
        this.context = formulaContext;
        this.numberFormats = this.loadNumberFormats();
    }

    protected NumberFormat[] loadNumberFormats() {
        ArrayList<DecimalFormat> arrayList = new ArrayList<DecimalFormat>();
        DecimalFormat decimalFormat = new DecimalFormat("#0.###", new DecimalFormatSymbols(Locale.US));
        this.activateBigDecimalMode(decimalFormat);
        arrayList.add(decimalFormat);
        return arrayList.toArray(new NumberFormat[arrayList.size()]);
    }

    private void activateBigDecimalMode(DecimalFormat decimalFormat) {
        if (ObjectUtilities.isJDK14()) {
            try {
                Method method = DecimalFormat.class.getMethod("setParseBigDecimal", Boolean.TYPE);
                method.invoke((Object)decimalFormat, Boolean.TRUE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String convertToText(Type type, Object object) throws EvaluationException {
        if (object == null) {
            return "";
        }
        if (type.isFlagSet("type.text")) {
            return this.computeStringValue(object);
        }
        if (type.isFlagSet("type.logical")) {
            if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                if (Boolean.TRUE.equals(bl)) {
                    return "TRUE";
                }
                return "FALSE";
            }
            throw new TypeConversionException();
        }
        if (type.isFlagSet("type.numeric")) {
            if (type.isFlagSet("type.datetime") || type.isFlagSet("type.date") || type.isFlagSet("type.time")) {
                java.util.Date date = this.convertToDate(type, object);
                List list = this.context.getLocalizationContext().getDateFormats(type);
                if (list != null && list.size() >= 1) {
                    DateFormat dateFormat = (DateFormat)list.get(0);
                    return dateFormat.format(date);
                }
                return DateFormat.getDateTimeInstance(0, 0).format(date);
            }
            try {
                Number number = this.convertToNumber(type, object);
                NumberFormat numberFormat = this.getDefaultNumberFormat();
                return numberFormat.format(number);
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        return this.computeStringValue(object);
    }

    private String computeStringValue(Object object) {
        if (object instanceof Clob) {
            return this.readClob((Clob)object);
        }
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    private String readClob(Clob clob) {
        try {
            return clob.getSubString(0L, (int)clob.length());
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @Override
    public Boolean convertToLogical(Type type, Object object) throws TypeConversionException {
        if (object == null) {
            return Boolean.FALSE;
        }
        if (type.isFlagSet("type.logical") || type.isFlagSet("type.any")) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if ("true".equalsIgnoreCase(String.valueOf(object))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (type.isFlagSet("type.numeric")) {
            Number number;
            if (object instanceof Number && !ZERO.equals(number = (Number)object)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (type.isFlagSet("type.text")) {
            String string = this.computeStringValue(object);
            if ("TRUE".equalsIgnoreCase(string)) {
                return Boolean.TRUE;
            }
            if ("FALSE".equalsIgnoreCase(string)) {
                return Boolean.FALSE;
            }
        }
        throw new TypeConversionException();
    }

    @Override
    public java.util.Date convertToDate(Type type, Object object) throws EvaluationException {
        if ((type.isFlagSet("type.numeric") || type.isFlagSet("type.any")) && (type.isFlagSet("type.date") || type.isFlagSet("type.datetime") || type.isFlagSet("type.time") || type.isFlagSet("type.any")) && object instanceof java.util.Date) {
            return DateUtil.normalizeDate((java.util.Date)object, type);
        }
        Number number = this.convertToNumber(type, object);
        BigDecimal bigDecimal = NumberUtil.getAsBigDecimal(number);
        return HSSFDateUtil.getJavaDate(bigDecimal);
    }

    protected NumberFormat getDefaultNumberFormat() {
        Locale locale = this.context.getLocalizationContext().getLocale();
        return new DecimalFormat("#0.#########", new DecimalFormatSymbols(locale));
    }

    private TypeValuePair convertToSequence(Type type, TypeValuePair typeValuePair) throws EvaluationException {
        if (type.isFlagSet("type.numeric.sequence")) {
            return new TypeValuePair(type, this.convertToNumberSequence(typeValuePair.getType(), typeValuePair.getValue(), true));
        }
        return new TypeValuePair(type, this.convertToSequence(typeValuePair.getType(), typeValuePair.getValue()));
    }

    @Override
    public Sequence convertToSequence(Type type, Object object) throws EvaluationException {
        if (type.isFlagSet("type.scalar")) {
            return new AnySequence(new StaticValue(object, type), this.context);
        }
        if (type.isFlagSet("type.sequence")) {
            if (object instanceof AnySequence) {
                return (AnySequence)object;
            }
            logger.warn((Object)"Assertation failure: Type declared to be a sequence, but no sequence found inside.");
            throw new TypeConversionException();
        }
        if (type.isFlagSet("type.array")) {
            if (object instanceof ArrayCallback) {
                return new AnySequence((ArrayCallback)object, this.context);
            }
            logger.warn((Object)"Assertation failure: Type declared to be array, but no array callback found inside.");
            throw new TypeConversionException();
        }
        throw new TypeConversionException();
    }

    @Override
    public NumberSequence convertToNumberSequence(Type type, Object object, boolean bl) throws EvaluationException {
        if (type.isFlagSet("type.numeric.sequence")) {
            if (object instanceof DefaultNumberSequence) {
                return (NumberSequence)object;
            }
            return new DefaultNumberSequence(this.context);
        }
        if (type.isFlagSet("type.array")) {
            if (object instanceof ArrayCallback) {
                if (bl) {
                    return new DefaultNumberSequence((ArrayCallback)object, this.context);
                }
                return new AnyNumberSequence((ArrayCallback)object, this.context);
            }
            logger.warn((Object)"Assertation failure: Type declared to be array, but no array callback found inside.");
            throw new TypeConversionException();
        }
        if (type.isFlagSet("type.scalar") || type.isFlagSet("type.numeric")) {
            return new DefaultNumberSequence(new StaticValue((Object)this.convertToNumber(type, object), NumberType.GENERIC_NUMBER), this.context);
        }
        return new DefaultNumberSequence(this.context);
    }

    @Override
    public TypeValuePair convertTo(Type type, TypeValuePair typeValuePair) throws EvaluationException {
        Object object;
        if (type.isFlagSet("type.array")) {
            if (typeValuePair.getType().isFlagSet("type.array")) {
                if (typeValuePair.getType().isFlagSet("type.sequence")) {
                    return this.convertToSequence(type, typeValuePair);
                }
                if (type.isFlagSet("type.sequence")) {
                    return this.convertToSequence(type, typeValuePair);
                }
                return this.convertArrayToArray(type, typeValuePair);
            }
            if (type.isFlagSet("type.sequence")) {
                return this.convertToSequence(type, typeValuePair);
            }
            Object object2 = this.convertPlainToPlain(type, typeValuePair.getType(), typeValuePair.getValue());
            return new TypeValuePair(type, new ArrayConverterCallback(object2, type));
        }
        Object object3 = typeValuePair.getValue();
        if (object3 == (object = this.convertPlainToPlain(type, typeValuePair.getType(), object3))) {
            return typeValuePair;
        }
        return new TypeValuePair(type, object);
    }

    private Object convertPlainToPlain(Type type, Type type2, Object object) throws EvaluationException {
        if (type.isFlagSet("type.numeric")) {
            if (type.isFlagSet("type.logical")) {
                if (type2.isFlagSet("type.logical")) {
                    return object;
                }
                return this.convertToLogical(type2, object);
            }
            if (object instanceof java.util.Date && (type.isFlagSet("type.date") || type.isFlagSet("type.datetime") || type.isFlagSet("type.time"))) {
                java.util.Date date = (java.util.Date)object;
                return DateUtil.normalizeDate(date, type, false);
            }
            Number number = this.convertToNumber(type2, object);
            if (type.isFlagSet("type.date") || type.isFlagSet("type.datetime") || type.isFlagSet("type.time")) {
                BigDecimal bigDecimal = NumberUtil.getAsBigDecimal(number);
                BigDecimal bigDecimal2 = DateUtil.normalizeDate(bigDecimal, type);
                java.util.Date date = HSSFDateUtil.getJavaDate(bigDecimal2);
                return DateUtil.normalizeDate(date, type, false);
            }
            return number;
        }
        if (type.isFlagSet("type.text")) {
            return this.convertToText(type2, object);
        }
        return object;
    }

    private TypeValuePair convertArrayToArray(Type type, TypeValuePair typeValuePair) throws TypeConversionException {
        throw new TypeConversionException();
    }

    @Override
    public Type guessTypeOfObject(Object object) {
        if (object instanceof Number) {
            return NumberType.GENERIC_NUMBER;
        }
        if (object instanceof Time) {
            return DateTimeType.TIME_TYPE;
        }
        if (object instanceof Date) {
            return DateTimeType.DATE_TYPE;
        }
        if (object instanceof java.util.Date) {
            return DateTimeType.DATETIME_TYPE;
        }
        if (object instanceof Boolean) {
            return LogicalType.TYPE;
        }
        if (object instanceof String) {
            return TextType.TYPE;
        }
        return AnyType.TYPE;
    }

    static {
        ZERO = NUM_FALSE = new BigDecimal("0");
    }

    private static class ArrayConverterCallback
    implements ArrayCallback {
        private Object retval;
        private Type targetType;

        private ArrayConverterCallback(Object object, Type type) {
            this.retval = object;
            this.targetType = type;
        }

        @Override
        public LValue getRaw(int n, int n2) {
            return null;
        }

        @Override
        public Object getValue(int n, int n2) throws EvaluationException {
            if (n == 0 && n2 == 0) {
                return this.retval;
            }
            return null;
        }

        @Override
        public Type getType(int n, int n2) throws EvaluationException {
            if (n == 0 && n2 == 0) {
                return this.targetType;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return 1;
        }
    }
}

