/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.typing;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.typing.ExtendedComparator;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class DefaultComparator
implements ExtendedComparator {
    private FormulaContext context;
    private static final int LESS = -1;
    private static final int EQUAL = 0;
    private static final int MORE = 1;

    public void inititalize(FormulaContext formulaContext) {
        if (formulaContext == null) {
            throw new NullPointerException();
        }
        this.context = formulaContext;
    }

    @Override
    public boolean isEqual(Type type, Object object, Type type2, Object object2) {
        TypeRegistry typeRegistry = this.context.getTypeRegistry();
        try {
            Number number = typeRegistry.convertToNumber(type, object);
            Number number2 = typeRegistry.convertToNumber(type2, object2);
            BigDecimal bigDecimal = NumberUtil.getAsBigDecimal(number);
            BigDecimal bigDecimal2 = NumberUtil.getAsBigDecimal(number2);
            if (bigDecimal.signum() != bigDecimal2.signum()) {
                return false;
            }
            BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
            return bigDecimal3.signum() == 0;
        }
        catch (EvaluationException evaluationException) {
            if (type.isFlagSet("type.text") || type2.isFlagSet("type.text")) {
                String string = null;
                String string2 = null;
                try {
                    string = typeRegistry.convertToText(type, object);
                    string2 = typeRegistry.convertToText(type2, object2);
                }
                catch (EvaluationException evaluationException2) {
                    // empty catch block
                }
                if (string == null && string2 == null) {
                    return true;
                }
                if (string == null || string2 == null) {
                    return false;
                }
                return ObjectUtilities.equal((Object)string, (Object)string2);
            }
            return ObjectUtilities.equal((Object)object, (Object)object2);
        }
    }

    @Override
    public int compare(Type type, Object object, Type type2, Object object2) {
        Object object3;
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (type.isFlagSet("type.scalar") && type2.isFlagSet("type.scalar") && object instanceof Comparable && object2 instanceof Comparable) {
            object3 = (Comparable)object;
            try {
                int n = object3.compareTo(object2);
                if (n == 0) {
                    return 0;
                }
                if (n > 0) {
                    return 1;
                }
                return -1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object3 = this.context.getTypeRegistry();
        try {
            BigDecimal bigDecimal;
            Number number = object3.convertToNumber(type, object);
            Number number2 = object3.convertToNumber(type2, object2);
            BigDecimal bigDecimal2 = NumberUtil.getAsBigDecimal(number);
            BigDecimal bigDecimal3 = NumberUtil.getAsBigDecimal(number2);
            if (bigDecimal2.signum() != bigDecimal3.signum()) {
                if (bigDecimal2.signum() < 0) {
                    return -1;
                }
                if (bigDecimal2.signum() > 0) {
                    return 1;
                }
            }
            if ((bigDecimal = bigDecimal2.subtract(bigDecimal3)).signum() == 0) {
                return 0;
            }
            if (bigDecimal.signum() > 0) {
                return 1;
            }
            return -1;
        }
        catch (EvaluationException evaluationException) {
            String string = null;
            String string2 = null;
            try {
                string = object3.convertToText(type, object);
                string2 = object3.convertToText(type2, object2);
            }
            catch (EvaluationException evaluationException2) {
                // empty catch block
            }
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            int n = string.compareTo(string2);
            if (n == 0) {
                return 0;
            }
            if (n > 0) {
                return 1;
            }
            return -1;
        }
    }
}

