/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.DivideOperator;
import org.pentaho.reporting.libraries.formula.operators.PostfixOperator;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class PercentageOperator
implements PostfixOperator {
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final long serialVersionUID = -5578115447971169716L;

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, TypeValuePair typeValuePair) throws EvaluationException {
        Object object = typeValuePair.getValue();
        if (object == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        Type type = typeValuePair.getType();
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        if (!type.isFlagSet("type.numeric") && !type.isFlagSet("type.any")) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        Number number = typeRegistry.convertToNumber(type, object);
        BigDecimal bigDecimal = NumberUtil.getAsBigDecimal(number);
        BigDecimal bigDecimal2 = DivideOperator.divide(bigDecimal, HUNDRED);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, bigDecimal2);
    }

    public String toString() {
        return "%";
    }
}

