/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.PrefixOperator;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class MinusSignOperator
implements PrefixOperator {
    private static final BigDecimal ZERO = new BigDecimal(0);
    private static final long serialVersionUID = 7453766552980074751L;

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, TypeValuePair typeValuePair) throws EvaluationException {
        Type type = typeValuePair.getType();
        Object object = typeValuePair.getValue();
        if (object == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        if (type.isFlagSet("type.numeric")) {
            TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
            Number number = typeRegistry.convertToNumber(type, object);
            if (number == null) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            BigDecimal bigDecimal = NumberUtil.getAsBigDecimal(number);
            return new TypeValuePair(NumberType.GENERIC_NUMBER, ZERO.subtract(bigDecimal));
        }
        if (object instanceof Number) {
            BigDecimal bigDecimal = NumberUtil.getAsBigDecimal((Number)object);
            if (bigDecimal == null) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            return new TypeValuePair(type, ZERO.subtract(bigDecimal));
        }
        throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
    }

    public String toString() {
        return "-";
    }
}

