/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.InfixOperator;
import org.pentaho.reporting.libraries.formula.typing.ExtendedComparator;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class EqualOperator
implements InfixOperator {
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final long serialVersionUID = 2865411431720931171L;

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, TypeValuePair typeValuePair, TypeValuePair typeValuePair2) throws EvaluationException {
        Type type;
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Object object = typeValuePair.getValue();
        Object object2 = typeValuePair2.getValue();
        if (object == null || object2 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        Type type2 = typeValuePair.getType();
        ExtendedComparator extendedComparator = typeRegistry.getComparator(type2, type = typeValuePair2.getType());
        boolean bl = extendedComparator.isEqual(type2, object, type, object2);
        if (bl) {
            return RETURN_TRUE;
        }
        return RETURN_FALSE;
    }

    @Override
    public int getLevel() {
        return 400;
    }

    public String toString() {
        return "=";
    }

    @Override
    public boolean isLeftOperation() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return false;
    }
}

