/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.operators.AbstractNumericOperator;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class DivideOperator
extends AbstractNumericOperator {
    private static final long serialVersionUID = 3298154333839229191L;

    @Override
    public Number evaluate(Number number, Number number2) throws EvaluationException {
        BigDecimal bigDecimal = NumberUtil.getAsBigDecimal(number);
        BigDecimal bigDecimal2 = NumberUtil.getAsBigDecimal(number2);
        return DivideOperator.divide(bigDecimal, bigDecimal2);
    }

    public static BigDecimal divide(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws EvaluationException {
        if (bigDecimal2.signum() == 0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARITHMETIC_VALUE);
        }
        BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, 40, 4);
        return NumberUtil.removeTrailingZeros(bigDecimal3);
    }

    @Override
    public int getLevel() {
        return 100;
    }

    public String toString() {
        return "/";
    }

    @Override
    public boolean isLeftOperation() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return false;
    }
}

