/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.InfixOperator;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class ConcatOperator
implements InfixOperator {
    private static final long serialVersionUID = 6579968694761281257L;

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, TypeValuePair typeValuePair, TypeValuePair typeValuePair2) throws EvaluationException {
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Object object = typeValuePair.getValue();
        Object object2 = typeValuePair2.getValue();
        if (object == null || object2 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        String string = typeRegistry.convertToText(typeValuePair.getType(), object);
        String string2 = typeRegistry.convertToText(typeValuePair2.getType(), object2);
        if (string == null && string2 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (string == null) {
            return new TypeValuePair(TextType.TYPE, string2);
        }
        if (string2 == null) {
            return new TypeValuePair(TextType.TYPE, string);
        }
        return new TypeValuePair(TextType.TYPE, string + string2);
    }

    @Override
    public int getLevel() {
        return 300;
    }

    public String toString() {
        return "&";
    }

    @Override
    public boolean isLeftOperation() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return false;
    }
}

