/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.lvalues;

import java.util.ArrayList;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.AbstractLValue;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.ParsePosition;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.InfixOperator;

public class Term
extends AbstractLValue {
    private static final LValue[] EMPTY_L_VALUE = new LValue[0];
    private static final InfixOperator[] EMPTY_OPERATOR = new InfixOperator[0];
    private static final long serialVersionUID = -1854082494425470979L;
    private LValue optimizedHeadValue;
    private LValue headValue;
    private ArrayList operators;
    private ArrayList operands;
    private InfixOperator[] operatorArray;
    private LValue[] operandsArray;
    private boolean initialized;

    public Term(LValue lValue) {
        if (lValue == null) {
            throw new NullPointerException();
        }
        this.headValue = lValue;
    }

    @Override
    public TypeValuePair evaluate() throws EvaluationException {
        TypeValuePair typeValuePair = this.optimizedHeadValue.evaluate();
        for (int i = 0; i < this.operandsArray.length; ++i) {
            LValue lValue = this.operandsArray[i];
            InfixOperator infixOperator = this.operatorArray[i];
            typeValuePair = infixOperator.evaluate(this.getContext(), typeValuePair, lValue.evaluate());
        }
        return typeValuePair;
    }

    public void add(InfixOperator infixOperator, LValue lValue) {
        if (infixOperator == null) {
            throw new NullPointerException();
        }
        if (lValue == null) {
            throw new NullPointerException();
        }
        if (this.operands == null || this.operators == null) {
            this.operands = new ArrayList();
            this.operators = new ArrayList();
        }
        this.operands.add(lValue);
        this.operators.add(infixOperator);
        this.initialized = false;
    }

    @Override
    public void initialize(FormulaContext formulaContext) throws EvaluationException {
        super.initialize(formulaContext);
        if (this.operands == null || this.operators == null) {
            this.optimizedHeadValue = this.headValue;
            this.optimizedHeadValue.initialize(formulaContext);
            this.operandsArray = EMPTY_L_VALUE;
            this.operatorArray = EMPTY_OPERATOR;
            return;
        }
        if (this.initialized) {
            this.optimizedHeadValue.initialize(formulaContext);
            for (int i = 0; i < this.operandsArray.length; ++i) {
                LValue lValue = this.operandsArray[i];
                lValue.initialize(formulaContext);
            }
            return;
        }
        this.optimize(formulaContext);
    }

    private void optimize(FormulaContext formulaContext) throws EvaluationException {
        ArrayList arrayList = (ArrayList)this.operators.clone();
        ArrayList arrayList2 = (ArrayList)this.operands.clone();
        this.optimizedHeadValue = this.headValue;
        block0: while (true) {
            InfixOperator infixOperator = (InfixOperator)arrayList.get(0);
            int n = infixOperator.getLevel();
            boolean bl = false;
            for (int i = 1; i < arrayList.size(); ++i) {
                InfixOperator infixOperator2 = (InfixOperator)arrayList.get(i);
                int n2 = infixOperator2.getLevel();
                if (n2 == n) continue;
                bl = true;
                n = Math.min(n2, n);
            }
            if (!bl) break;
            Term term = null;
            int n3 = 0;
            while (true) {
                if (n3 >= arrayList.size()) continue block0;
                InfixOperator infixOperator3 = (InfixOperator)arrayList.get(n3);
                if (infixOperator3.getLevel() != n) {
                    term = null;
                } else {
                    LValue lValue;
                    if (term == null) {
                        if (n3 == 0) {
                            term = new Term(this.optimizedHeadValue);
                            this.optimizedHeadValue = term;
                        } else {
                            lValue = (LValue)arrayList2.get(n3 - 1);
                            term = new Term(lValue);
                            arrayList2.set(n3 - 1, term);
                        }
                    }
                    lValue = (LValue)arrayList2.get(n3);
                    term.add(infixOperator3, lValue);
                    arrayList2.remove(n3);
                    arrayList.remove(n3);
                    --n3;
                }
                ++n3;
            }
            break;
        }
        this.operatorArray = arrayList.toArray(new InfixOperator[arrayList.size()]);
        this.operandsArray = arrayList2.toArray(new LValue[arrayList2.size()]);
        this.optimizedHeadValue.initialize(formulaContext);
        for (int i = 0; i < this.operandsArray.length; ++i) {
            LValue lValue = this.operandsArray[i];
            lValue.initialize(formulaContext);
        }
    }

    @Override
    public LValue[] getChildValues() {
        LValue[] lValueArray = new LValue[this.operandsArray.length + 1];
        lValueArray[0] = this.headValue;
        System.arraycopy(this.operandsArray, 0, lValueArray, 1, this.operandsArray.length);
        return lValueArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append('(');
        stringBuffer.append(this.headValue);
        if (this.operands != null && this.operators != null) {
            for (int i = 0; i < this.operands.size(); ++i) {
                InfixOperator infixOperator = (InfixOperator)this.operators.get(i);
                LValue lValue = (LValue)this.operands.get(i);
                stringBuffer.append(infixOperator);
                stringBuffer.append(lValue);
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public boolean isConstant() {
        if (!this.headValue.isConstant()) {
            return false;
        }
        for (int i = 0; i < this.operands.size(); ++i) {
            LValue lValue = (LValue)this.operands.get(i);
            if (lValue.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Term term = (Term)super.clone();
        if (this.operands != null) {
            term.operands = (ArrayList)this.operands.clone();
        }
        if (this.operators != null) {
            term.operators = (ArrayList)this.operators.clone();
        }
        term.headValue = (LValue)this.headValue.clone();
        term.optimizedHeadValue = null;
        term.operandsArray = null;
        term.operatorArray = null;
        term.initialized = false;
        return term;
    }

    public InfixOperator[] getOperands() {
        return this.operands.toArray(new InfixOperator[this.operands.size()]);
    }

    public LValue[] getOperators() {
        return this.operators.toArray(new LValue[this.operators.size()]);
    }

    public LValue getHeadValue() {
        return this.headValue;
    }

    public LValue getOptimizedHeadValue() {
        return this.optimizedHeadValue;
    }

    @Override
    public ParsePosition getParsePosition() {
        ParsePosition parsePosition = super.getParsePosition();
        if (parsePosition == null) {
            int n = this.headValue.getParsePosition().getStartColumn();
            int n2 = this.headValue.getParsePosition().getStartLine();
            ParsePosition parsePosition2 = this.operandsArray[this.operandsArray.length - 1].getParsePosition();
            int n3 = parsePosition2.getEndColumn();
            int n4 = parsePosition2.getEndLine();
            this.setParsePosition(new ParsePosition(n2, n, n4, n3));
        }
        return super.getParsePosition();
    }
}

