/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.lvalues;

import org.pentaho.reporting.libraries.base.util.ObjectTable;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.DataTable;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.ParsePosition;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;

public class DefaultDataTable
extends ObjectTable
implements DataTable {
    private transient Boolean constant;
    private static final LValue[] EMPTY_LVALUES = new LValue[0];
    private static final long serialVersionUID = 4942690291611203409L;
    private ParsePosition parsePosition;

    public DefaultDataTable() {
    }

    public DefaultDataTable(LValue[][] lValueArray) {
        if (lValueArray != null && lValueArray.length > 0) {
            int n = lValueArray[0].length;
            this.setData(lValueArray, n);
        }
    }

    @Override
    public ParsePosition getParsePosition() {
        return this.parsePosition;
    }

    public void setParsePosition(ParsePosition parsePosition) {
        this.parsePosition = parsePosition;
    }

    @Override
    public String getColumnName(int n) {
        StringBuffer stringBuffer = new StringBuffer(10);
        while (n >= 0) {
            int n2 = (char)(n % 26) + 65;
            stringBuffer.append(n2);
            n = n / 26 - 1;
        }
        return stringBuffer.toString();
    }

    public void setObject(int n, int n2, LValue lValue) {
        super.setObject(n, n2, (Object)lValue);
    }

    @Override
    public LValue getValueAt(int n, int n2) {
        return (LValue)this.getObject(n, n2);
    }

    @Override
    public void initialize(FormulaContext formulaContext) throws EvaluationException {
        int n = this.getRowCount();
        int n2 = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                LValue lValue = this.getValueAt(i, j);
                if (lValue == null) continue;
                lValue.initialize(formulaContext);
            }
        }
    }

    @Override
    public TypeValuePair evaluate() throws EvaluationException {
        int n = -1;
        LValue[][] lValueArray = (LValue[][])this.getData();
        for (int i = 0; i < lValueArray.length; ++i) {
            LValue[] lValueArray2 = lValueArray[i];
            if (n > 0 && lValueArray2.length != n) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_ILLEGAL_ARRAY_VALUE);
            }
            n = lValueArray2.length;
        }
        return new TypeValuePair(AnyType.ANY_ARRAY, new DefaultArrayCallback(this));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultDataTable defaultDataTable = (DefaultDataTable)super.clone();
        Object[][] objectArray = this.getData();
        Object[][] objectArray2 = (Object[][])objectArray.clone();
        for (int i = 0; i < objectArray2.length; ++i) {
            Object[] objectArray3 = objectArray2[i];
            if (objectArray3 == null) continue;
            objectArray2[i] = (Object[])objectArray3.clone();
            for (int j = 0; j < objectArray3.length; ++j) {
                LValue lValue = (LValue)objectArray3[j];
                if (lValue == null) continue;
                objectArray3[j] = lValue.clone();
            }
        }
        defaultDataTable.setData(objectArray2, this.getColumnCount());
        return defaultDataTable;
    }

    @Override
    public Type getValueType() {
        return AnyType.ANY_ARRAY;
    }

    @Override
    public LValue[] getChildValues() {
        return EMPTY_LVALUES;
    }

    @Override
    public boolean isConstant() {
        if (this.constant == null) {
            this.constant = this.computeConstantValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.TRUE.equals(this.constant);
    }

    private boolean computeConstantValue() {
        int n = this.getRowCount();
        int n2 = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                LValue lValue = this.getValueAt(i, j);
                if (lValue.isConstant()) continue;
                return false;
            }
        }
        return true;
    }

    private static class DefaultArrayCallback
    implements ArrayCallback {
        private DefaultDataTable table;
        private TypeValuePair[][] backend;

        private DefaultArrayCallback(DefaultDataTable defaultDataTable) {
            this.table = defaultDataTable;
            this.backend = new TypeValuePair[defaultDataTable.getRowCount()][defaultDataTable.getColumnCount()];
        }

        @Override
        public LValue getRaw(int n, int n2) {
            return this.table.getValueAt(n, n2);
        }

        @Override
        public Object getValue(int n, int n2) throws EvaluationException {
            TypeValuePair typeValuePair = this.get(n, n2);
            return typeValuePair.getValue();
        }

        private TypeValuePair get(int n, int n2) throws EvaluationException {
            TypeValuePair typeValuePair = this.backend[n][n2];
            if (typeValuePair == null) {
                this.backend[n][n2] = typeValuePair = this.getRaw(n, n2).evaluate();
            }
            return typeValuePair;
        }

        @Override
        public Type getType(int n, int n2) throws EvaluationException {
            return this.get(n, n2).getType();
        }

        @Override
        public int getColumnCount() {
            return this.table.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return this.table.getRowCount();
        }
    }
}

