/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.lvalues;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.AbstractLValue;
import org.pentaho.reporting.libraries.formula.lvalues.ParsePosition;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.ErrorType;

public class ContextLookup
extends AbstractLValue {
    private String name;
    private static final long serialVersionUID = 2882834743999159722L;

    public ContextLookup(String string) {
        this(string, null);
    }

    public ContextLookup(String string, ParsePosition parsePosition) {
        this.name = string;
        this.setParsePosition(parsePosition);
    }

    @Override
    public TypeValuePair evaluate() throws EvaluationException {
        FormulaContext formulaContext = this.getContext();
        Object object = formulaContext.resolveReference(this.name);
        Type type = formulaContext.resolveReferenceType(this.name);
        return new TypeValuePair(type, object);
    }

    @Override
    public Type getValueType() {
        try {
            FormulaContext formulaContext = this.getContext();
            return formulaContext.resolveReferenceType(this.name);
        }
        catch (EvaluationException evaluationException) {
            return ErrorType.TYPE;
        }
    }

    public String toString() {
        return '[' + this.name + ']';
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public String getName() {
        return this.name;
    }
}

